/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.polynomials.Polynomial;

public class LeastSquaresDivision {
    public static final double EPS = 1.0E-9;
    private double err_;
    private double[] coeff;

    public boolean divide(Polynomial num, Polynomial denom) {
        try {
            this.err_ = 0.0;
            DataBlock N = new DataBlock(num);
            DataBlock D = new DataBlock(denom);
            int n = N.getLength();
            int d = D.getLength();
            if (d > n) {
                return false;
            }
            int q = n - d + 1;
            this.coeff = new double[q];
            Matrix m = new Matrix(n, q);
            DataBlockIterator columns = m.columns();
            DataBlock column = columns.getData();
            int c = 0;
            do {
                column.range(c, c + d).copy(D);
                ++c;
            } while (columns.next());
            Householder qr = new Householder(false);
            qr.decompose(m);
            DataBlock E = new DataBlock(d - 1);
            qr.leastSquares(N, new DataBlock(this.coeff), E);
            this.err_ = E.nrm2() / (double)d;
            return true;
        }
        catch (MatrixException err) {
            return false;
        }
    }

    public Polynomial getQuotient() {
        return Polynomial.of(this.coeff);
    }

    public double getError() {
        return this.err_;
    }

    public boolean isExact() {
        return this.err_ < 1.0E-9;
    }
}

