/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.SubArray;
import ec.tstoolkit.design.PrimitiveReplacementOf;
import ec.tstoolkit.utilities.Arrays2;

@PrimitiveReplacementOf(generic=SubArray.class, primitive=boolean.class)
public final class SubArrayOfBoolean {
    public static final SubArrayOfBoolean EMPTY = SubArrayOfBoolean.create(Arrays2.EMPTY_BOOLEAN_ARRAY);
    private final boolean[] m_data;
    private final int m_beg;
    private final int m_end;
    private final int m_inc;

    public static SubArrayOfBoolean create(boolean[] data) {
        return new SubArrayOfBoolean(data, 0, data.length, 1);
    }

    public static SubArrayOfBoolean create(boolean[] data, int beg, int end, int inc) {
        return new SubArrayOfBoolean(data, beg, end, inc);
    }

    private SubArrayOfBoolean(boolean[] data, int beg, int end, int inc) {
        this.m_data = data;
        this.m_beg = beg;
        this.m_end = end;
        this.m_inc = inc;
    }

    public void copy(SubArrayOfBoolean a) {
        int tcur = this.m_beg;
        int scur = a.m_beg;
        if (this.m_inc == 1 && a.m_inc == 1) {
            while (tcur != this.m_end) {
                this.m_data[tcur++] = a.m_data[scur++];
            }
        } else {
            while (tcur != this.m_end) {
                this.m_data[tcur] = a.m_data[scur];
                tcur += this.m_inc;
                scur += a.m_inc;
            }
        }
    }

    public void copyFrom(boolean[] a, int start) {
        int tcur;
        int scur = start;
        if (this.m_inc == 1) {
            while (tcur != this.m_end) {
                this.m_data[tcur++] = a[scur++];
            }
        } else {
            for (tcur = this.m_beg; tcur != this.m_end; tcur += this.m_inc) {
                this.m_data[tcur] = a[scur++];
            }
        }
    }

    public boolean get(int idx) {
        return this.m_data[this.m_beg + idx * this.m_inc];
    }

    public int getLength() {
        return this.m_inc == 0 ? 0 : (this.m_end - this.m_beg) / this.m_inc;
    }

    public boolean isEmpty() {
        return this.m_beg == this.m_end;
    }

    public SubArrayOfBoolean range(int i0, int i1) {
        return new SubArrayOfBoolean(this.m_data, this.m_beg + i0 * this.m_inc, this.m_beg + i1 * this.m_inc, this.m_inc);
    }

    public void set(boolean tval) {
        int cur;
        if (this.m_inc == 1) {
            while (cur != this.m_end) {
                this.m_data[cur++] = tval;
            }
        } else {
            for (cur = this.m_beg; cur != this.m_end; cur += this.m_inc) {
                this.m_data[cur] = tval;
            }
        }
    }

    public void set(int idx, boolean value) {
        this.m_data[this.m_beg + idx * this.m_inc] = value;
    }
}

