/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.ssf.FastFilter;
import ec.tstoolkit.ssf.FastInitializer;
import ec.tstoolkit.ssf.PredictionErrorDecomposition;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.arima.SsfArima;

public class FastArimaForecasts {
    private final SsfArima ssf_;
    private final BackFilter bar_;
    private double mean;
    private double ssqErr;
    private boolean bmean;

    public double getSsqErr() {
        return this.ssqErr;
    }

    public double getMean() {
        return this.mean;
    }

    public FastArimaForecasts(IArimaModel model, boolean mean) {
        this.bmean = mean;
        IArimaModel cmodel = model;
        if (mean) {
            BackFilter ar = model.getStationaryAR();
            BackFilter ur = model.getNonStationaryAR();
            BackFilter ma = model.getMA();
            this.bar_ = ar.times(ur);
            double var = model.getInnovationVariance();
            BackFilter D = BackFilter.D1;
            cmodel = new ArimaModel(ar, ur.times(D), ma.times(D), var);
        } else {
            this.bar_ = model.getAR();
        }
        this.ssf_ = new SsfArima(cmodel);
    }

    private double[] fcasts(SsfData sd, int nf) {
        FastInitializer<SsfArima> initializer = new FastInitializer<SsfArima>(new SsfArima.Initializer());
        FastFilter<SsfArima> filter = new FastFilter<SsfArima>();
        filter.setInitializer(initializer);
        filter.setSsf(this.ssf_);
        PredictionErrorDecomposition perr = new PredictionErrorDecomposition(false);
        filter.process(sd, perr);
        this.ssqErr = perr.getSsqErr();
        double[] f = new double[nf];
        DataBlock a = filter.getState().A;
        int dim = a.getLength();
        if (nf >= this.ssf_.getStateDim()) {
            a.copyTo(f, 0);
            int last = dim - 1;
            for (int i = dim; i < nf; ++i) {
                this.ssf_.TX(a);
                f[i] = a.get(last);
            }
        } else {
            filter.getState().A.range(0, nf).copyTo(f, 0);
        }
        if (this.bmean) {
            this.mean = a.range(dim - this.bar_.getLength(), dim).dotReverse(this.bar_.getCoefficients());
        }
        return f;
    }

    public double[] forecasts(double[] data, int nf) {
        SsfData sd = new SsfData(data, null);
        return this.fcasts(sd, nf);
    }

    public double[] forecasts(IReadDataBlock data, int nf) {
        SsfData sd = new SsfData(data, null);
        return this.fcasts(sd, nf);
    }
}

