/*
 * Decompiled with CFR 0.152.
 */
package jd2.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jd2.datatypes.Ts;
import jd2.datatypes.TsInformationType;
import jd2.datatypes.TsMoniker;
import lombok.Generated;
import lombok.NonNull;

public final class TsCollection {
    @NonNull
    private final TsMoniker moniker;
    @NonNull
    private final TsInformationType type;
    @NonNull
    private final String name;
    private final Map<String, String> metaData;
    private final List<Ts> items;

    @Generated
    TsCollection(@NonNull TsMoniker moniker, @NonNull TsInformationType type, @NonNull String name, Map<String, String> metaData, List<Ts> items) {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.moniker = moniker;
        this.type = type;
        this.name = name;
        this.metaData = metaData;
        this.items = items;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public TsMoniker getMoniker() {
        return this.moniker;
    }

    @NonNull
    @Generated
    public TsInformationType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    @Generated
    public List<Ts> getItems() {
        return this.items;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsCollection)) {
            return false;
        }
        TsCollection other = (TsCollection)o;
        TsMoniker this$moniker = this.getMoniker();
        TsMoniker other$moniker = other.getMoniker();
        if (this$moniker == null ? other$moniker != null : !((Object)this$moniker).equals(other$moniker)) {
            return false;
        }
        TsInformationType this$type = this.getType();
        TsInformationType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$metaData = this.getMetaData();
        Map<String, String> other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        List<Ts> this$items = this.getItems();
        List<Ts> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TsMoniker $moniker = this.getMoniker();
        result = result * 59 + ($moniker == null ? 43 : ((Object)$moniker).hashCode());
        TsInformationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        List<Ts> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TsCollection(moniker=" + this.getMoniker() + ", type=" + this.getType() + ", name=" + this.getName() + ", metaData=" + this.getMetaData() + ", items=" + this.getItems() + ")";
    }

    public static class Builder {
        @Generated
        private TsMoniker moniker;
        @Generated
        private TsInformationType type;
        @Generated
        private String name;
        @Generated
        private ArrayList<String> metaData$key;
        @Generated
        private ArrayList<String> metaData$value;
        @Generated
        private ArrayList<Ts> items;

        public TsMoniker getMoniker() {
            return this.moniker;
        }

        public TsInformationType getType() {
            return this.type;
        }

        @Generated
        Builder() {
        }

        @Generated
        public Builder moniker(@NonNull TsMoniker moniker) {
            if (moniker == null) {
                throw new NullPointerException("moniker is marked non-null but is null");
            }
            this.moniker = moniker;
            return this;
        }

        @Generated
        public Builder type(@NonNull TsInformationType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public Builder meta(String metaKey, String metaValue) {
            if (this.metaData$key == null) {
                this.metaData$key = new ArrayList();
                this.metaData$value = new ArrayList();
            }
            this.metaData$key.add(metaKey);
            this.metaData$value.add(metaValue);
            return this;
        }

        @Generated
        public Builder metaData(Map<? extends String, ? extends String> metaData) {
            if (metaData == null) {
                throw new NullPointerException("metaData cannot be null");
            }
            if (this.metaData$key == null) {
                this.metaData$key = new ArrayList();
                this.metaData$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : metaData.entrySet()) {
                this.metaData$key.add($lombokEntry.getKey());
                this.metaData$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public Builder clearMetaData() {
            if (this.metaData$key != null) {
                this.metaData$key.clear();
                this.metaData$value.clear();
            }
            return this;
        }

        @Generated
        public Builder item(Ts item) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(item);
            return this;
        }

        @Generated
        public Builder items(Collection<? extends Ts> items) {
            if (items == null) {
                throw new NullPointerException("items cannot be null");
            }
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.addAll(items);
            return this;
        }

        @Generated
        public Builder clearItems() {
            if (this.items != null) {
                this.items.clear();
            }
            return this;
        }

        @Generated
        public TsCollection build() {
            List<Ts> items;
            Map<String, String> metaData;
            switch (this.metaData$key == null ? 0 : this.metaData$key.size()) {
                case 0: {
                    metaData = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metaData = Collections.singletonMap(this.metaData$key.get(0), this.metaData$value.get(0));
                    break;
                }
                default: {
                    metaData = new LinkedHashMap(this.metaData$key.size() < 0x40000000 ? 1 + this.metaData$key.size() + (this.metaData$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metaData$key.size(); ++$i) {
                        metaData.put(this.metaData$key.get($i), this.metaData$value.get($i));
                    }
                    metaData = Collections.unmodifiableMap(metaData);
                }
            }
            switch (this.items == null ? 0 : this.items.size()) {
                case 0: {
                    items = Collections.emptyList();
                    break;
                }
                case 1: {
                    items = Collections.singletonList(this.items.get(0));
                    break;
                }
                default: {
                    items = Collections.unmodifiableList(new ArrayList<Ts>(this.items));
                }
            }
            return new TsCollection(this.moniker, this.type, this.name, metaData, items);
        }

        @Generated
        public String toString() {
            return "TsCollection.Builder(moniker=" + this.moniker + ", type=" + this.type + ", name=" + this.name + ", metaData$key=" + this.metaData$key + ", metaData$value=" + this.metaData$value + ", items=" + this.items + ")";
        }
    }
}

