/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit;

import ec.tstoolkit.ParameterType;
import ec.tstoolkit.utilities.Arrays2;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Formatter;
import java.util.Objects;

public class Parameter
implements Cloneable,
Comparable<Parameter> {
    private double value_;
    private double stde_;
    private ParameterType type_;
    private static final String EMPTY = "";

    public static Parameter[] clone(Parameter[] value) {
        if (Arrays2.isNullOrEmpty(value)) {
            return null;
        }
        Parameter[] p = new Parameter[value.length];
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) continue;
            p[i] = value[i].clone();
        }
        return p;
    }

    public static Parameter[] create(int n) {
        if (n == 0) {
            return null;
        }
        Parameter[] p = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            p[i] = new Parameter();
        }
        return p;
    }

    public static boolean hasFixedParameters(Parameter[] p) {
        if (p == null) {
            return false;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == null || p[i].type_ != ParameterType.Fixed) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFreeParameters(Parameter[] p) {
        if (p == null) {
            return false;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] != null && p[i].type_ == ParameterType.Fixed) continue;
            return true;
        }
        return false;
    }

    public static int countFixedParameters(Parameter[] p) {
        if (p == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == null || p[i].type_ != ParameterType.Fixed) continue;
            ++n;
        }
        return n;
    }

    public static int countFreeParameters(Parameter[] p) {
        if (p == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] != null && p[i].type_ == ParameterType.Fixed) continue;
            ++n;
        }
        return n;
    }

    public static boolean isDefault(Parameter[] p) {
        if (p == null) {
            return true;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == null || p[i].type_ == ParameterType.Undefined) continue;
            return false;
        }
        return true;
    }

    public static boolean isDefault(Parameter p) {
        if (p == null) {
            return true;
        }
        return p.type_ == ParameterType.Undefined;
    }

    public static boolean isDefined(Parameter[] p) {
        if (p == null) {
            return true;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] != null && p[i].type_ != ParameterType.Undefined) continue;
            return false;
        }
        return true;
    }

    public static boolean isDefined(Parameter p) {
        return p != null && p.type_ != ParameterType.Undefined;
    }

    public static boolean isZero(Parameter[] p) {
        if (p == null) {
            return true;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == null || p[i].value_ == 0.0) continue;
            return false;
        }
        return true;
    }

    public Parameter() {
        this.type_ = ParameterType.Undefined;
    }

    public Parameter(double value, ParameterType type) {
        this.type_ = type;
        this.value_ = value;
    }

    public Parameter clone() {
        try {
            return (Parameter)super.clone();
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    @Override
    public int compareTo(Parameter p) {
        int r = Double.compare(this.value_, p.value_);
        if (r != 0) {
            return r;
        }
        return this.type_.compareTo(p.type_);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Parameter && this.equals((Parameter)obj);
    }

    public boolean equals(Parameter other) {
        return this.value_ == other.value_ && this.type_ == other.type_ && this.stde_ == other.stde_;
    }

    public double getStde() {
        return this.stde_;
    }

    public ParameterType getType() {
        return this.type_;
    }

    public double getValue() {
        return this.value_;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Jdk6.Double.hashCode(this.value_);
        hash = 59 * hash + Objects.hashCode((Object)this.type_);
        return hash;
    }

    public void setStde(double value) {
        this.stde_ = value;
    }

    public void setType(ParameterType value) {
        this.type_ = value;
        if (this.type_ == ParameterType.Undefined) {
            this.value_ = 0.0;
            this.stde_ = 0.0;
        } else if (this.type_ != ParameterType.Estimated && this.type_ != ParameterType.Derived) {
            this.stde_ = 0.0;
        }
    }

    public void setValue(double value) {
        this.value_ = value;
    }

    public boolean isFixed() {
        return this.type_ == ParameterType.Fixed;
    }

    public String toString() {
        return this.toString("%4g");
    }

    public String toString(String fmt) {
        if (this.type_ == ParameterType.Undefined) {
            return EMPTY;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(new Formatter().format(fmt, this.value_).toString());
        if (this.type_ == ParameterType.Fixed) {
            builder.append('f');
        } else if (this.stde_ > 0.0) {
            builder.append(" (").append(new Formatter().format(fmt, this.stde_).toString()).append(')');
        }
        return builder.toString();
    }
}

