/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima.estimation;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.Utilities;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;

public class DefaultSarimaMapping
implements IParametricMapping<SarimaModel> {
    public static final String PHI = "phi";
    public static final String BPHI = "bphi";
    public static final String TH = "th";
    public static final String BTH = "bth";
    static final double REPS = 0.01;
    static final double MAX = 0.99999;
    static final double RMAX = 0.985;
    static final double STEP = 1.0E-6;
    private double rmax_ = 1.0;
    public final SarimaSpecification spec;

    private static boolean checkStability(double d) {
        return Math.abs(d) < 1.0;
    }

    private static boolean checkStability(double a, double b) {
        double ro = b * b - 4.0 * a;
        if (ro < 0.0) {
            return Math.abs(a) < 1.0;
        }
        double sro = Math.sqrt(ro);
        double r = (-b + sro) / (2.0 * a);
        if (Math.abs(1.0 / r) >= 1.0) {
            return false;
        }
        r = (-b - sro) / (2.0 * a);
        return Math.abs(1.0 / r) < 1.0;
    }

    private static boolean checkStability(IReadDataBlock c, int start, int nc) {
        if (nc == 0) {
            return true;
        }
        if (nc == 1) {
            return DefaultSarimaMapping.checkStability(c.get(start));
        }
        if (nc == 2) {
            return DefaultSarimaMapping.checkStability(c.get(start + 1), c.get(start));
        }
        return Utilities.checkStability(c.rextract(start, nc));
    }

    private static boolean stabilize(SarimaSpecification spec, IDataBlock p) {
        boolean rslt = false;
        if (spec.getP() > 0 && DefaultSarimaMapping.stabilize(p, 0, spec.getP())) {
            rslt = true;
        }
        if (spec.getBP() > 0 && DefaultSarimaMapping.stabilize(p, spec.getP(), spec.getBP())) {
            rslt = true;
        }
        if (spec.getQ() > 0 && DefaultSarimaMapping.stabilize(p, spec.getP() + spec.getBP(), spec.getQ())) {
            rslt = true;
        }
        if (spec.getBQ() > 0 && DefaultSarimaMapping.stabilize(p, spec.getP() + spec.getBP() + spec.getQ(), spec.getBQ())) {
            rslt = true;
        }
        return rslt;
    }

    private static boolean stabilize(IDataBlock c, int start, int nc) {
        Polynomial sp;
        if (nc == 0) {
            return false;
        }
        if (DefaultSarimaMapping.checkStability(c, start, nc)) {
            return false;
        }
        if (nc == 1) {
            double c0 = c.get(start);
            double cabs = Math.abs(c0);
            if (cabs > 1.0) {
                c.set(start, 1.0 / c0);
                return true;
            }
            return false;
        }
        double[] ctmp = new double[nc + 1];
        ctmp[0] = 1.0;
        for (int i = 0; i < nc; ++i) {
            ctmp[1 + i] = c.get(start + i);
        }
        Polynomial p = Polynomial.of(ctmp);
        if (p != (sp = DefaultSarimaMapping.stabilize(p))) {
            for (int i = 0; i < nc; ++i) {
                c.set(start + i, sp.get(1 + i));
            }
            return true;
        }
        return false;
    }

    private static Polynomial stabilize(Polynomial p) {
        if (p == null) {
            return null;
        }
        Complex[] roots = p.roots();
        boolean changed = false;
        for (int i = 0; i < roots.length; ++i) {
            Complex root = roots[i];
            double n = 1.0 / roots[i].abs();
            if (!(n > 1.0)) continue;
            roots[i] = root.inv();
            changed = true;
        }
        if (!changed) {
            return p;
        }
        Polynomial ptmp = Polynomial.fromComplexRoots(roots);
        ptmp = ptmp.divide(ptmp.get(0));
        return ptmp;
    }

    public static boolean stabilize(SarimaModel m) {
        DataBlock np = new DataBlock(m.getParameters());
        if (DefaultSarimaMapping.stabilize(m.getSpecification(), np)) {
            m.setParameters(np);
            return true;
        }
        return false;
    }

    public DefaultSarimaMapping(SarimaSpecification spec) {
        this.spec = spec;
    }

    @Override
    public boolean checkBoundaries(IReadDataBlock p) {
        if (this.spec.getP() > 0 && !DefaultSarimaMapping.checkStability(p, 0, this.spec.getP())) {
            return false;
        }
        if (this.spec.getBP() > 0 && !DefaultSarimaMapping.checkStability(p, this.spec.getP(), this.spec.getBP())) {
            return false;
        }
        if (this.spec.getQ() > 0 && !DefaultSarimaMapping.checkStability(p, this.spec.getP() + this.spec.getBP(), this.spec.getQ())) {
            return false;
        }
        return this.spec.getBQ() <= 0 || DefaultSarimaMapping.checkStability(p, this.spec.getP() + this.spec.getBP() + this.spec.getQ(), this.spec.getBQ());
    }

    @Override
    public double epsilon(IReadDataBlock inparams, int idx) {
        double p = inparams.get(idx);
        if (p < 0.0) {
            return 1.0E-6 * Math.max(1.0, -p);
        }
        return -1.0E-6 * Math.max(1.0, p);
    }

    @Override
    public int getDim() {
        return this.spec.getParametersCount();
    }

    @Override
    public double lbound(int idx) {
        if (this.spec.getP() > 0) {
            if (idx < this.spec.getP()) {
                if (this.spec.getP() == 1) {
                    return -0.99999;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getP();
        }
        if (this.spec.getBP() > 0) {
            if (idx < this.spec.getBP()) {
                if (this.spec.getBP() == 1) {
                    return -0.99999;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getBP();
        }
        if (this.spec.getQ() > 0) {
            if (idx < this.spec.getQ()) {
                if (this.spec.getQ() == 1) {
                    return -0.99999;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getQ();
        }
        if (this.spec.getBQ() == 1) {
            return -0.99999;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public SarimaModel map(IReadDataBlock p) {
        if (p.getLength() != this.spec.getParametersCount()) {
            return null;
        }
        SarimaModel m = new SarimaModel(this.spec);
        m.setParameters(p);
        return m;
    }

    @Override
    public IReadDataBlock map(SarimaModel t) {
        SarimaSpecification curspec = t.getSpecification();
        if (curspec.getP() != this.spec.getP() || curspec.getQ() != this.spec.getQ() || curspec.getBP() != this.spec.getBP() || curspec.getBQ() != this.spec.getBQ()) {
            return null;
        }
        return t.getParameters();
    }

    public boolean stabilize(IDataBlock p) {
        return DefaultSarimaMapping.stabilize(this.spec, p);
    }

    @Override
    public double ubound(int idx) {
        if (this.spec.getP() > 0) {
            if (idx < this.spec.getP()) {
                if (this.spec.getP() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getP();
        }
        if (this.spec.getBP() > 0) {
            if (idx < this.spec.getBP()) {
                if (this.spec.getBP() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getBP();
        }
        if (this.spec.getQ() > 0) {
            if (idx < this.spec.getQ()) {
                if (this.spec.getQ() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getQ();
        }
        if (this.spec.getBQ() == 1) {
            return 0.99999;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ParamValidation validate(IDataBlock value) {
        if (value.getLength() != this.spec.getParametersCount()) {
            return ParamValidation.Invalid;
        }
        if (DefaultSarimaMapping.stabilize(this.spec, value)) {
            return ParamValidation.Changed;
        }
        return ParamValidation.Valid;
    }

    @Override
    public String getDescription(int idx) {
        return DefaultSarimaMapping.getDescription(this.spec, idx);
    }

    static String getDescription(SarimaSpecification xspec, int idx) {
        int i = idx;
        if (i < xspec.getP()) {
            return DefaultSarimaMapping.desc(PHI, i);
        }
        if ((i -= xspec.getP()) < xspec.getBP()) {
            return DefaultSarimaMapping.desc(BPHI, i);
        }
        if ((i -= xspec.getBP()) < xspec.getQ()) {
            return DefaultSarimaMapping.desc(TH, i);
        }
        if ((i -= xspec.getQ()) < xspec.getBQ()) {
            return DefaultSarimaMapping.desc(BTH, i);
        }
        return "";
    }

    static String desc(String prefix, int idx) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append('(').append(idx + 1).append(')');
        return builder.toString();
    }
}

