/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;

public final class LowerTriangularMatrix {
    public static Matrix inverse(Matrix L) throws MatrixException {
        int n = L.ncols_;
        Matrix rslt = Matrix.identity(n);
        DataBlockIterator cols = rslt.columns();
        DataBlock cur = cols.getData();
        do {
            LowerTriangularMatrix.rsolve(L, cur);
        } while (cols.next());
        return rslt;
    }

    public static void lmul(Matrix L, DataBlock left) {
        int n = L.nrows_;
        double[] data = L.data_;
        double[] x = left.getData();
        int xinc = left.getIncrement();
        int xbeg = left.getStartPosition();
        int xend = left.getEndPosition();
        if (xinc == 1) {
            int xi = xbeg;
            int idx = 0;
            while (xi < xend) {
                double t = 0.0;
                int xj = xi;
                int idx2 = idx;
                while (xj < xend) {
                    t += data[idx2] * x[xj];
                    ++xj;
                    ++idx2;
                }
                x[xi] = t;
                ++xi;
                idx += n + 1;
            }
        } else {
            int xi = xbeg;
            int idx = 0;
            while (xi != xend) {
                double t = 0.0;
                int xj = xi;
                int idx2 = idx;
                while (xj != xend) {
                    t += data[idx2] * x[xj];
                    xj += xinc;
                    ++idx2;
                }
                x[xi] = t;
                xi += xinc;
                idx += n + 1;
            }
        }
    }

    @Deprecated
    public static void lmul2(Matrix L, DataBlock left) {
        int n = L.nrows_;
        double[] data = L.data_;
        int nb = left.getLength();
        int i = 0;
        int idx = 0;
        while (i < nb) {
            double t = 0.0;
            int j = i;
            int idx2 = idx;
            while (j < nb) {
                t += data[idx2] * left.get(j);
                ++j;
                ++idx2;
            }
            left.set(i, t);
            ++i;
            idx += n + 1;
        }
    }

    @Deprecated
    public static void lmul(Matrix L, double[] left) {
        LowerTriangularMatrix.lmul(L, new DataBlock(left));
    }

    public static void lmul(Matrix L, SubMatrix left) {
        DataBlockIterator rows = left.rows();
        DataBlock cur = rows.getData();
        do {
            LowerTriangularMatrix.lmul(L, cur);
        } while (rows.next());
    }

    public static void lsolve(Matrix L, DataBlock b) throws MatrixException {
        LowerTriangularMatrix.lsolve(L, b, 0.0);
    }

    @Deprecated
    public static void lsolve2(Matrix L, DataBlock b) throws MatrixException {
        LowerTriangularMatrix.lsolve2(L, b, 0.0);
    }

    public static void lsolve(Matrix L, DataBlock b, double zero) throws MatrixException {
        int n = L.nrows_;
        double[] data = L.data_;
        double[] x = b.getData();
        int xinc = b.getIncrement();
        int xend = b.getEndPosition();
        int nb = b.getLength();
        int xi = xend - xinc;
        int i = nb * n - 1;
        while (i >= 0) {
            double t = x[xi];
            int j = i + 1;
            for (int xj = xi + xinc; xj != xend; xj += xinc) {
                t -= x[xj] * data[j];
                ++j;
            }
            if (Math.abs(t) <= zero) {
                x[xi] = 0.0;
            } else {
                double d = data[i];
                if (d == 0.0) {
                    throw new MatrixException("m_err_sing");
                }
                x[xi] = t / d;
            }
            i -= n + 1;
            xi -= xinc;
        }
    }

    @Deprecated
    public static void lsolve2(Matrix L, DataBlock b, double zero) throws MatrixException {
        int n = L.ncols_;
        double[] data = L.data_;
        int nb = b.getLength();
        int i = nb - 1;
        int idx = (n + 1) * i;
        while (i >= 0) {
            int idx2 = idx + 1;
            double t = b.get(i);
            int j = i + 1;
            while (j < nb) {
                t -= b.get(j) * data[idx2];
                ++j;
                ++idx2;
            }
            double d = data[idx];
            if (Math.abs(t) <= zero) {
                b.set(i, 0.0);
            } else {
                if (d == 0.0) {
                    throw new MatrixException("m_err_sing");
                }
                b.set(i, t / d);
            }
            --i;
            idx -= n + 1;
        }
    }

    public static void lsolve(Matrix L, double[] b) throws MatrixException {
        LowerTriangularMatrix.lsolve(L, new DataBlock(b));
    }

    public static void lsolve(Matrix L, SubMatrix B, double zero) throws MatrixException {
        DataBlockIterator rows = B.rows();
        DataBlock cur = rows.getData();
        do {
            LowerTriangularMatrix.lsolve(L, cur, zero);
        } while (rows.next());
    }

    public static void lsolve(Matrix L, SubMatrix B) throws MatrixException {
        LowerTriangularMatrix.lsolve(L, B, 0.0);
    }

    @Deprecated
    public static void rmul2(Matrix L, DataBlock r) {
        int nb = r.getLength();
        int n = L.ncols_;
        double[] data = L.data_;
        double[] x = r.getData();
        int xinc = r.getIncrement();
        int xbeg = r.getStartPosition();
        int xend = r.getEndPosition();
        int xi = xend;
        for (int i = nb - 1; i >= 0; --i) {
            double t = 0.0;
            int xj = xbeg;
            int idx = i;
            while (xj != xi) {
                t += data[idx] * x[xj];
                xj += xinc;
                idx += n;
            }
            x[xi -= xinc] = t;
        }
    }

    public static void rmul(Matrix L, DataBlock r) {
        int nb = r.getLength();
        int nr = L.nrows_;
        double[] data = L.data_;
        double[] x = r.getData();
        int xinc = r.getIncrement();
        int xend = r.getEndPosition();
        if (xinc == 1) {
            int li = nr * nb - 1;
            int xi = xend - 1;
            while (li >= 0) {
                double z = x[xi];
                if (z != 0.0) {
                    x[xi] = data[li] * z;
                    int xj = xi + 1;
                    int idx = li + 1;
                    while (xj < xend) {
                        int n = xj++;
                        x[n] = x[n] + data[idx] * z;
                        ++idx;
                    }
                }
                li -= nr + 1;
                --xi;
            }
        } else {
            int li = nr * nb - 1;
            int xi = xend - xinc;
            while (li >= 0) {
                double z = x[xi];
                if (z != 0.0) {
                    x[xi] = data[li] * z;
                    int xj = xi + xinc;
                    int idx = li + 1;
                    while (xj != xend) {
                        int n = xj;
                        x[n] = x[n] + data[idx] * z;
                        xj += xinc;
                        ++idx;
                    }
                }
                li -= nr + 1;
                xi -= xinc;
            }
        }
    }

    public static void rmul(Matrix L, double[] r) {
        LowerTriangularMatrix.rmul(L, new DataBlock(r));
    }

    public static void rmul(Matrix L, SubMatrix R) {
        DataBlockIterator cols = R.columns();
        DataBlock cur = cols.getData();
        do {
            LowerTriangularMatrix.rmul(L, cur);
        } while (cols.next());
    }

    public static void rsolve2(Matrix L, DataBlock b, double zero) throws MatrixException {
        int n = L.nrows_;
        double[] data = L.data_;
        double[] x = b.getData();
        int xbeg = b.getStartPosition();
        int xinc = b.getIncrement();
        int xend = b.getEndPosition();
        int i = 0;
        for (int xi = xbeg; xi != xend; xi += xinc) {
            int idx = i;
            double t = x[xi];
            int xj = xbeg;
            while (xj != xi) {
                t -= x[xj] * data[idx];
                xj += xinc;
                idx += n;
            }
            if (Math.abs(t) > zero) {
                double d = data[idx];
                if (d == 0.0) {
                    throw new MatrixException("m_err_sing");
                }
                x[xi] = t / d;
            }
            ++i;
        }
    }

    public static void rsolve(Matrix L, DataBlock b) {
        LowerTriangularMatrix.rsolve(L, b, 0.0);
    }

    public static void rsolve2(Matrix L, DataBlock b) {
        LowerTriangularMatrix.rsolve2(L, b, 0.0);
    }

    public static void rsolve(Matrix L, DataBlock b, double zero) throws MatrixException {
        int n = L.nrows_;
        double[] data = L.data_;
        double[] x = b.getData();
        int xbeg = b.getStartPosition();
        int xinc = b.getIncrement();
        int xend = b.getEndPosition();
        if (xinc == 1) {
            int i = 0;
            for (int xi = xbeg; xi < xend; ++xi) {
                double t = x[xi];
                if (Math.abs(t) > zero) {
                    double c;
                    double d = data[i];
                    if (d == 0.0) {
                        throw new MatrixException("m_err_sing");
                    }
                    x[xi] = c = t / d;
                    int xj = xi + 1;
                    int j = i + 1;
                    while (xj < xend) {
                        int n2 = xj++;
                        x[n2] = x[n2] - c * data[j];
                        ++j;
                    }
                } else {
                    x[xi] = 0.0;
                }
                i += n + 1;
            }
        } else {
            int i = 0;
            for (int xi = xbeg; xi != xend; xi += xinc) {
                double t = x[xi];
                if (Math.abs(t) > zero) {
                    double c;
                    double d = data[i];
                    if (d == 0.0) {
                        throw new MatrixException("m_err_sing");
                    }
                    x[xi] = c = t / d;
                    int xj = xi + xinc;
                    int j = i + 1;
                    while (xj != xend) {
                        int n3 = xj;
                        x[n3] = x[n3] - c * data[j];
                        xj += xinc;
                        ++j;
                    }
                } else {
                    x[xi] = 0.0;
                }
                i += n + 1;
            }
        }
    }

    public static void rsolve(Matrix lower, double[] b) throws MatrixException {
        LowerTriangularMatrix.rsolve(lower, new DataBlock(b));
    }

    public static void rsolve(Matrix L, SubMatrix B) throws MatrixException {
        LowerTriangularMatrix.rsolve(L, B, 0.0);
    }

    public static void rsolve(Matrix L, SubMatrix B, double zero) throws MatrixException {
        DataBlockIterator cols = B.columns();
        DataBlock cur = cols.getData();
        do {
            LowerTriangularMatrix.rsolve(L, cur, zero);
        } while (cols.next());
    }

    public static void addXaXt(Matrix S, double a, DataBlock x) {
        if (a == 0.0) {
            return;
        }
        double[] s = S.data_;
        double[] z = x.getData();
        int n = S.ncols_;
        int beg = x.getStartPosition();
        int inc = x.getIncrement();
        if (inc == 1) {
            int c = 0;
            int k = 0;
            int l = beg;
            while (c < n) {
                double x1 = z[l];
                if (x1 != 0.0) {
                    x1 *= a;
                    int r = c;
                    int m = l;
                    while (r < n) {
                        int n2 = k++;
                        s[n2] = s[n2] + x1 * z[m];
                        ++r;
                        ++m;
                    }
                } else {
                    k += n - c;
                }
                k += ++c;
                ++l;
            }
        } else {
            int c = 0;
            int k = 0;
            int l = beg;
            while (c < n) {
                double x1 = z[l];
                if (x1 != 0.0) {
                    x1 *= a;
                    int r = c;
                    int m = l;
                    while (r < n) {
                        int n3 = k++;
                        s[n3] = s[n3] + x1 * z[m];
                        ++r;
                        m += inc;
                    }
                } else {
                    k += n - c;
                }
                k += ++c;
                l += inc;
            }
        }
    }

    private LowerTriangularMatrix() {
    }
}

