/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.ArmaEvaluation;
import ec.tstoolkit.arima.estimation.ArmaFunction;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.arima.estimation.IRegArimaProcessor;
import ec.tstoolkit.arima.estimation.KalmanFilter;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;

public class IGlsArimaMonitor<S extends IArimaModel>
implements IRegArimaProcessor<S> {
    private IArmaFilter m_filter1 = new KalmanFilter(false);
    private IArmaFilter m_filter2 = new KalmanFilter(true);
    private int m_flimit = 1;
    private boolean m_ml = true;
    private boolean m_llog;
    private IFunctionMinimizer m_min = null;
    private IParametricMapping<S> m_mapper;
    private boolean m_bconverged;
    private ArmaFunction<S> m_fn;
    private ArmaEvaluation<S> m_efn;
    private Matrix m_curvature;
    private double m_obj;
    private double m_precision = 1.0E-7;

    public IArmaFilter getFilter1() {
        return this.m_filter1;
    }

    public IArmaFilter getFilter2() {
        return this.m_filter2;
    }

    public int getFilterLimit() {
        return this.m_flimit;
    }

    public IParametricMapping<S> getMapping() {
        return this.m_mapper;
    }

    public IFunctionMinimizer getMinimizer() {
        return this.m_min;
    }

    @Override
    public double getPrecision() {
        return this.m_precision;
    }

    public boolean hasConverged() {
        return this.m_bconverged;
    }

    public S initialize(RegArimaModel<S> regs) {
        return null;
    }

    public boolean isUsingLogLikelihood() {
        return this.m_llog;
    }

    public boolean isUsingML() {
        return this.m_ml;
    }

    @Override
    public RegArimaEstimation<S> optimize(RegArimaModel<S> regs) {
        return this.optimize(regs, regs.getArma());
    }

    public RegArimaEstimation<S> optimize(RegArimaModel<S> regs, S start) {
        try {
            IFunctionMinimizer fmin;
            if (this.m_min != null) {
                fmin = this.m_min.exemplar();
                if (fmin instanceof ProxyMinimizer) {
                    this.m_llog = false;
                }
            } else {
                fmin = new ProxyMinimizer(new LevenbergMarquardtMethod());
                fmin.setConvergenceCriterion(this.m_precision);
                this.m_llog = false;
            }
            ArmaEvaluation nfn = null;
            RegModel dmodel = regs.getDModel();
            RegModel cmodel = new RegModel();
            S arma = start;
            if (arma == null) {
                arma = regs.getArma();
            }
            ArmaFunction<S> fn = new ArmaFunction<S>(dmodel, regs.getArima().getNonStationaryARCount(), regs.getMissings(), this.m_mapper);
            fn.filter = regs.getVarsCount() > this.m_flimit ? this.m_filter2 : this.m_filter1;
            this.m_efn = new ArmaEvaluation<S>(fn, arma);
            ConcentratedLikelihood ll = this.m_efn.getLikelihood();
            double obj1 = ll.getLogLikelihood();
            double obj0 = 0.0;
            int niter = 0;
            do {
                obj0 = obj1;
                DataBlock e = dmodel.calcRes(new DataBlock(ll.getB()));
                cmodel.setY(e);
                ArmaFunction<S> cfn = new ArmaFunction<S>(cmodel, 0, null, this.m_mapper);
                cfn.llog = this.m_llog;
                cfn.ml = this.m_ml;
                cfn.filter = this.m_filter1;
                ArmaEvaluation<S> fstart = new ArmaEvaluation<S>(cfn, arma);
                this.m_bconverged = fmin.minimize(cfn, fstart);
                nfn = (ArmaEvaluation)fmin.getResult();
                arma = nfn.arma;
                if (dmodel.getVarsCount() > 0) {
                    this.m_efn = new ArmaEvaluation<S>(fn, arma);
                    ll = this.m_efn.getLikelihood();
                    obj1 = ll.getLogLikelihood();
                    continue;
                }
                this.m_efn = nfn;
                ll = nfn.getLikelihood();
            } while (niter++ <= 50 && (Double.isNaN(obj1) || obj1 - obj0 > this.m_precision));
            RegArimaModel<IArimaModel> nregs = new RegArimaModel<IArimaModel>(regs);
            IArimaModel narima = (IArimaModel)this.m_mapper.map(this.m_efn.getParameters());
            if (narima != null) {
                nregs.setArima(narima);
            }
            RegArimaEstimation rslt = new RegArimaEstimation(nregs, ll);
            this.m_curvature = fmin.getCurvature();
            this.m_obj = fmin.getObjective();
            return rslt;
        }
        catch (BaseException ex) {
            return null;
        }
    }

    @Override
    public RegArimaEstimation<S> process(RegArimaModel<S> regs) {
        S start = this.initialize(regs);
        return this.optimize(regs, start);
    }

    public void setFilter1(IArmaFilter value) {
        this.m_filter1 = value;
    }

    public void setFilter2(IArmaFilter value) {
        this.m_filter2 = value;
    }

    public void setFilterLimit(int value) {
        this.m_flimit = value;
    }

    public void setMapping(IParametricMapping<S> value) {
        this.m_mapper = value;
    }

    public void setMinimizer(IFunctionMinimizer value) {
        this.m_min = value;
        if (this.m_min != null) {
            this.m_min.setConvergenceCriterion(this.m_precision);
        }
    }

    @Override
    public void setPrecision(double value) {
        this.m_precision = value;
        if (this.m_min != null) {
            this.m_min.setConvergenceCriterion(value);
        }
    }

    public void useLogLikelihood(boolean value) {
        this.m_llog = value;
    }

    public void useML(boolean value) {
        this.m_ml = value;
    }

    public Matrix getCurvature() {
        if (this.m_efn == null) {
            return null;
        }
        if (this.m_curvature == null) {
            this.m_curvature = this.m_fn.getDerivatives(this.m_efn).getHessian();
        }
        return this.m_curvature;
    }

    public Matrix getInformationMatrix() {
        if (this.m_efn == null) {
            return null;
        }
        if (this.m_curvature == null) {
            this.m_curvature = this.m_fn.getDerivatives(this.m_efn).getHessian();
        }
        if (this.m_llog) {
            return this.m_curvature;
        }
        return this.m_curvature.times(0.5 / this.m_obj);
    }

    public double getMinimum() {
        return this.m_obj;
    }
}

