/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.arima.RegArimaEstimator;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.SarimaFixedMapping;

public class TramoModelEstimator
extends RegArimaEstimator {
    public static final double TRAMO_EPS = 1.0E-4;

    public TramoModelEstimator(IParametricMapping<SarimaModel> mapping) {
        super(mapping);
        this.eps_ = 1.0E-4;
        super.setStartingPoint(RegArimaEstimator.StartingPoint.HannanRissanen);
    }

    @Override
    protected void computepvar(GlsSarimaMonitor monitor, RegArimaEstimation<SarimaModel> rslt) {
        int n = rslt.likelihood.getDegreesOfFreedom(true, this.mapping_.getDim());
        Matrix information = monitor.getObservedInformation(n);
        if (information == null) {
            return;
        }
        this.pcov_ = SymmetricMatrix.inverse(information);
        if (this.pcov_ == null) {
            return;
        }
        if (monitor.getMapping() instanceof SarimaFixedMapping) {
            SarimaFixedMapping mapping = (SarimaFixedMapping)monitor.getMapping();
            this.pcov_ = mapping.expandCovariance(this.pcov_);
        }
        this.calcDefVar(this.pcov_, n, (SarimaModel)rslt.model.getArima());
    }

    private int findFree(int pos, boolean[] fixed) {
        if (fixed == null) {
            return pos;
        }
        for (int cur = 0; cur < fixed.length; ++cur) {
            if (fixed[cur]) continue;
            if (pos == 0) {
                return cur;
            }
            --pos;
        }
        return -1;
    }

    private void calcDefVar(Matrix var, double denom, SarimaModel arima) {
        try {
            boolean[] fixed = null;
            if (this.mapping_ instanceof SarimaFixedMapping) {
                fixed = ((SarimaFixedMapping)this.mapping_).getFixedItems();
            }
            SarimaSpecification spec = arima.getSpecification();
            int np = spec.getParametersCount();
            int nf = 0;
            if (fixed != null) {
                for (int i = 0; i < fixed.length; ++i) {
                    if (!fixed[i]) continue;
                    ++nf;
                }
            }
            if (np - nf == 0) {
                return;
            }
            if (np - nf == 1) {
                int idx = this.findFree(0, fixed);
                double p = arima.getParameter(idx);
                var.set(idx, idx, (1.0 - p * p) / denom);
                return;
            }
            if (spec.isAirline(true) && nf == 0 && (Math.abs(arima.theta(1)) >= 0.9 || Math.abs(arima.btheta(1)) >= 0.9)) {
                double q = arima.theta(1);
                double bq = arima.btheta(1);
                Matrix curv = new Matrix(2, 2);
                curv.set(0, 0, 1.0 / (1.0 - q * q));
                curv.set(1, 1, 1.0 / (1.0 - bq * bq));
                double qc = Math.pow(-q, spec.getFrequency() - 1);
                curv.set(0, 1, qc / (1.0 - q * qc * bq));
                curv.set(1, 0, curv.get(0, 1));
                curv.mul(denom);
                Matrix newvar = SymmetricMatrix.inverse(curv);
                var.set(0, 0, newvar.get(0, 0));
                var.set(1, 0, newvar.get(1, 0));
                var.set(0, 1, var.get(1, 0));
                var.set(1, 1, newvar.get(1, 1));
                return;
            }
            if (np - nf == 2 && spec.getP() + spec.getQ() == 1 && spec.getBP() + spec.getBQ() == 1 && 1.0 - Math.abs(var.get(0, 1)) / Math.sqrt(var.get(0, 0) * var.get(1, 1)) <= 0.01) {
                var.set(0, 1, 0.0);
                var.set(1, 0, 0.0);
            }
        }
        catch (ArimaException | MatrixException err) {
            String string = err.getMessage();
        }
    }
}

