/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace;

import jd2.workspace.WorkspaceFamily;
import lombok.NonNull;

public final class WorkspaceItem {
    @NonNull
    private final WorkspaceFamily family;
    @NonNull
    private final String id;
    private final String label;
    private final boolean readOnly;
    private final String comments;

    WorkspaceItem(@NonNull WorkspaceFamily family, @NonNull String id, String label, boolean readOnly, String comments) {
        if (family == null) {
            throw new NullPointerException("family is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.family = family;
        this.id = id;
        this.label = label;
        this.readOnly = readOnly;
        this.comments = comments;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().family(this.family).id(this.id).label(this.label).readOnly(this.readOnly).comments(this.comments);
    }

    @NonNull
    public WorkspaceFamily getFamily() {
        return this.family;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getComments() {
        return this.comments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkspaceItem)) {
            return false;
        }
        WorkspaceItem other = (WorkspaceItem)o;
        WorkspaceFamily this$family = this.getFamily();
        WorkspaceFamily other$family = other.getFamily();
        if (this$family == null ? other$family != null : !((Object)this$family).equals(other$family)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        if (this.isReadOnly() != other.isReadOnly()) {
            return false;
        }
        String this$comments = this.getComments();
        String other$comments = other.getComments();
        return !(this$comments == null ? other$comments != null : !this$comments.equals(other$comments));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WorkspaceFamily $family = this.getFamily();
        result = result * 59 + ($family == null ? 43 : ((Object)$family).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        result = result * 59 + (this.isReadOnly() ? 79 : 97);
        String $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
        return result;
    }

    public String toString() {
        return "WorkspaceItem(family=" + this.getFamily() + ", id=" + this.getId() + ", label=" + this.getLabel() + ", readOnly=" + this.isReadOnly() + ", comments=" + this.getComments() + ")";
    }

    public static class Builder {
        private WorkspaceFamily family;
        private String id;
        private String label;
        private boolean readOnly;
        private String comments;

        Builder() {
        }

        public Builder family(@NonNull WorkspaceFamily family) {
            if (family == null) {
                throw new NullPointerException("family is marked non-null but is null");
            }
            this.family = family;
            return this;
        }

        public Builder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder comments(String comments) {
            this.comments = comments;
            return this;
        }

        public WorkspaceItem build() {
            return new WorkspaceItem(this.family, this.id, this.label, this.readOnly, this.comments);
        }

        public String toString() {
            return "WorkspaceItem.Builder(family=" + this.family + ", id=" + this.id + ", label=" + this.label + ", readOnly=" + this.readOnly + ", comments=" + this.comments + ")";
        }
    }
}

