/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.timeseries.simplets.ITsDataInterpolator;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.IntList;

public class AverageInterpolator
implements ITsDataInterpolator {
    public static boolean cleanMissings(double[] y, IntList missings) {
        int ny = y.length;
        int i0 = -1;
        int i1 = -1;
        for (int i = ny - 1; i >= 0; --i) {
            double cur = y[i];
            if (!Double.isFinite(cur)) {
                if (i1 == -1) {
                    i1 = i + 1;
                }
                i0 = i - 1;
                if (missings == null) continue;
                missings.add(i);
                continue;
            }
            if (i0 == -1) continue;
            double v = i1 >= ny ? y[i0] : (y[i1] + y[i0]) / 2.0;
            for (int j = i0 + 1; j < i1; ++j) {
                y[j] = v;
            }
            i1 = -1;
            i0 = -1;
        }
        if (i1 > 0) {
            if (i1 >= ny) {
                return false;
            }
            for (int j = 0; j < i1; ++j) {
                y[j] = y[i1];
            }
        }
        return true;
    }

    @Override
    public boolean interpolate(TsData data, IntList missingpos) {
        return AverageInterpolator.cleanMissings(data.internalStorage(), missingpos);
    }
}

