/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.arima;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.maths.realfunctions.SingleParameter;
import ec.tstoolkit.ssf.ISsf;

public class SsfAr1
implements ISsf {
    private boolean m_zeroinit;
    private double m_rho;

    public SsfAr1() {
        this.m_rho = 0.1;
    }

    public SsfAr1(double rho) {
        this.m_rho = rho;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        qm.set(0, 0, 1.0);
    }

    @Override
    public int getNonStationaryDim() {
        return 0;
    }

    public double getRho() {
        return this.m_rho;
    }

    @Override
    public int getStateDim() {
        return 1;
    }

    @Override
    public int getTransitionResCount() {
        return 1;
    }

    @Override
    public int getTransitionResDim() {
        return 1;
    }

    @Override
    public boolean hasR() {
        return false;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public boolean isDiffuse() {
        return false;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    public boolean isUsingZeroInitialization() {
        return this.m_zeroinit;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        lm.set(0, 0, this.m_rho - k.get(0));
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        if (this.m_zeroinit) {
            pf0.set(0, 0, 1.0);
        } else {
            pf0.set(0, 0, 1.0 / (1.0 - this.m_rho * this.m_rho));
        }
    }

    @Override
    public void Pi0(SubMatrix pi0) {
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.set(0, 0, 1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        rv.set(0);
    }

    public void setRho(double value) {
        this.m_rho = value;
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        tr.set(0, 0, this.m_rho);
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        vm.mul(this.m_rho * this.m_rho);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        x.mul(this.m_rho);
    }

    public void useZeroInitialization(boolean value) {
        this.m_zeroinit = value;
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        vm.add(d);
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        wv.set(1.0);
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.add(d);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        x.mul(this.m_rho);
    }

    @Override
    public void Z(int pos, DataBlock x) {
        x.set(0, 1.0);
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.set(0, m.get(0, 0));
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        return vm.get(0, 0);
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        return x.get(0);
    }

    public static class Mapping
    implements IParametricMapping<SsfAr1> {
        public static final String RHO = "rho";
        public final boolean zeroInit;
        public final double a_;
        public final double b_;
        public static final double EPS = Math.sqrt(2.220446E-16);
        public static final double BOUND = 0.99999999;

        public Mapping(boolean zeroInit) {
            this.zeroInit = zeroInit;
            this.a_ = -0.99999999;
            this.b_ = 0.99999999;
        }

        public Mapping(boolean zeroInit, double a, double b) {
            this.zeroInit = zeroInit;
            this.a_ = Math.max(a, -0.99999999);
            this.b_ = Math.min(b, 0.99999999);
        }

        @Override
        public boolean checkBoundaries(IReadDataBlock inparams) {
            double p = inparams.get(0);
            return p > this.a_ && p < this.b_;
        }

        @Override
        public double epsilon(IReadDataBlock inparams, int idx) {
            return inparams.get(0) > 0.0 ? -EPS / 2.0 : EPS / 2.0;
        }

        @Override
        public int getDim() {
            return 1;
        }

        @Override
        public double lbound(int idx) {
            return this.a_;
        }

        @Override
        public SsfAr1 map(IReadDataBlock p) {
            if (p.getLength() < 1) {
                return null;
            }
            SsfAr1 ar1 = new SsfAr1(p.get(0));
            ar1.m_zeroinit = this.zeroInit;
            return ar1;
        }

        @Override
        public IReadDataBlock map(SsfAr1 t) {
            return new SingleParameter(t.getRho());
        }

        @Override
        public double ubound(int idx) {
            return this.b_;
        }

        @Override
        public ParamValidation validate(IDataBlock ioparams) {
            double p = ioparams.get(0);
            ParamValidation rslt = ParamValidation.Valid;
            if (p < this.a_) {
                p = this.a_;
                ioparams.set(0, p);
                rslt = ParamValidation.Changed;
            } else if (p > this.b_) {
                p = this.b_;
                ioparams.set(0, p);
                rslt = ParamValidation.Changed;
            }
            return rslt;
        }

        @Override
        public String getDescription(int idx) {
            return RHO;
        }
    }
}

