/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.benchmarking.DisaggregationModel;
import ec.benchmarking.simplets.TsDisaggregation;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.GridSearch;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.ssf.arima.SsfAr1;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.regression.Constant;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.LinearTrend;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

@Deprecated
public class ChowLin {
    private TsData m_res;
    private TsData m_s;
    private TsData m_es;
    private TsAggregationType m_type = TsAggregationType.Sum;
    private boolean m_zinit;
    private boolean m_diffuseregs;
    private boolean ml_ = true;
    private boolean const_ = true;
    private boolean trend_;
    private DiffuseConcentratedLikelihood ll_;
    private double rho_;
    private double stdeRho_;
    private double eps_ = 1.0E-9;
    private IFunction fn_;

    public boolean process(TsData y, TsFrequency freq, int nfcasts) {
        this.clear();
        int yfreq = y.getFrequency().intValue();
        int ifreq = freq.intValue();
        if (ifreq % yfreq != 0) {
            return false;
        }
        int conv = ifreq / yfreq;
        DisaggregationModel model = new DisaggregationModel(freq);
        model.setY(y);
        if (this.const_) {
            model.getX().add(new Constant());
        }
        if (this.trend_) {
            model.getX().add(new LinearTrend(y.getStart().firstday()));
        }
        model.setAggregationType(this.m_type);
        TsDisaggregation<SsfAr1> disagg = this.algorithm();
        disagg.useML(this.ml_);
        TsDomain ndom = new TsDomain(freq, y.getStart().getYear(), y.getStart().getPosition() * conv, y.getLength() * conv + nfcasts);
        if (!disagg.process(model, ndom)) {
            return false;
        }
        this.analyse(disagg);
        return this.ll_ != null;
    }

    public boolean process(TsData y, TsVariableList x) {
        this.clear();
        if (x == null) {
            return false;
        }
        DisaggregationModel model = new DisaggregationModel(TsFrequency.Undefined);
        model.setY(y);
        if (this.const_) {
            model.getX().add(new Constant());
        }
        if (this.trend_) {
            model.getX().add(new LinearTrend(y.getStart().firstday()));
        }
        for (ITsVariable var : x.items()) {
            model.getX().add(var);
        }
        model.setAggregationType(this.m_type);
        int xfreq = x.getFrequency().intValue();
        int yfreq = y.getFrequency().intValue();
        if (xfreq == 0 || xfreq % yfreq != 0) {
            return false;
        }
        TsDisaggregation<SsfAr1> disagg = this.algorithm();
        if (!disagg.process(model, null)) {
            return false;
        }
        this.analyse(disagg);
        return this.ll_ != null;
    }

    private void analyse(TsDisaggregation<SsfAr1> disagg) {
        this.m_s = disagg.getSmoothedSeries();
        this.m_es = disagg.getSmoothedSeriesVariance().sqrt();
        this.rho_ = disagg.getEstimatedSsf().getRho();
        Matrix H = disagg.getObservedInformation();
        if (H != null) {
            this.stdeRho_ = Math.sqrt(1.0 / H.get(0, 0));
        }
        this.fn_ = disagg.getEstimationFunction();
        this.ll_ = disagg.getLikelihood();
        this.m_res = disagg.getFullResiduals();
    }

    private TsDisaggregation<SsfAr1> algorithm() {
        SsfAr1 ar1 = new SsfAr1(0.1);
        ar1.useZeroInitialization(this.m_zinit);
        TsDisaggregation<SsfAr1> disagg = new TsDisaggregation<SsfAr1>();
        disagg.setSsf(ar1);
        GridSearch gsearch = new GridSearch();
        gsearch.setPrecision(this.eps_);
        disagg.setMinimizer(gsearch);
        disagg.setEpsilon(this.eps_);
        disagg.setMapping(new SsfAr1.Mapping(this.m_zinit));
        disagg.calculateVariance(true);
        disagg.useML(this.ml_);
        if (this.m_diffuseregs) {
            disagg.setDiffuseRegressorsCount(-1);
        }
        return disagg;
    }

    private void clear() {
        this.m_s = null;
        this.m_es = null;
        this.ll_ = null;
        this.fn_ = null;
        this.stdeRho_ = 0.0;
    }

    public boolean isConstant() {
        return this.const_;
    }

    public void setConstant(boolean value) {
        this.const_ = value;
    }

    public boolean isTrend() {
        return this.trend_;
    }

    public void setTrend(boolean value) {
        this.trend_ = value;
    }

    public double getPrecision() {
        return this.eps_;
    }

    public void setPrecision(double value) {
        this.eps_ = value;
    }

    public boolean isMaximumLikelihood() {
        return this.ml_;
    }

    public void setMaximumLikelihood(boolean value) {
        this.ml_ = value;
    }

    public TsAggregationType getAggregationType() {
        return this.m_type;
    }

    public void setAggregationType(TsAggregationType value) {
        this.m_type = value;
    }

    public boolean isZeroInitialization() {
        return this.m_zinit;
    }

    public void setZeroInitialization(boolean value) {
        this.m_zinit = value;
    }

    public boolean isDiffuseRegressionCoefficients() {
        return this.m_diffuseregs;
    }

    public void setDiffuseRegressionCoefficients(boolean value) {
        this.m_diffuseregs = value;
    }

    public double getRho() {
        return this.rho_;
    }

    public double getRhoStde() {
        return this.stdeRho_;
    }

    public LikelihoodStatistics getLikelihoodStatistics() {
        if (this.ll_ == null) {
            return null;
        }
        LikelihoodStatistics stats = LikelihoodStatistics.create(this.ll_, this.ll_.getN(), 1, 0.0);
        return stats;
    }

    public TsData getResiduals() {
        return this.m_res;
    }

    public DiffuseConcentratedLikelihood getLikelihood() {
        return this.ll_;
    }

    public IFunction getLikelihoodFunction() {
        return this.fn_;
    }

    public TsData getDisaggregatedSeries() {
        return this.m_s;
    }

    public TsData getDisaggregatedSeriesStde() {
        return this.m_es;
    }
}

