/*
 * Decompiled with CFR 0.152.
 */
package jdr.spec.x13;

import ec.satoolkit.x13.X13Specification;
import jdr.spec.sa.SaBenchmarkingSpec;
import jdr.spec.x13.ArimaSpec;
import jdr.spec.x13.BasicSpec;
import jdr.spec.x13.EstimateSpec;
import jdr.spec.x13.OutlierSpec;
import jdr.spec.x13.RegressionSpec;
import jdr.spec.x13.TransformSpec;
import jdr.spec.x13.X11Spec;

public class X13Spec {
    final X13Specification core;

    public static X13Spec of(String spec) {
        X13Specification rspec = X13Specification.fromString((String)spec).clone();
        return new X13Spec(rspec);
    }

    public X13Spec(X13Specification spec) {
        this.core = spec;
    }

    public X13Specification getCore() {
        return this.core;
    }

    public BasicSpec getBasic() {
        return new BasicSpec(this.core.getRegArimaSpecification());
    }

    public RegressionSpec getRegression() {
        return new RegressionSpec(this.core.getRegArimaSpecification());
    }

    public TransformSpec getTransform() {
        return new TransformSpec(this.core.getRegArimaSpecification());
    }

    public ArimaSpec getArima() {
        return new ArimaSpec(this.core.getRegArimaSpecification());
    }

    public OutlierSpec getOutliers() {
        return new OutlierSpec(this.core.getRegArimaSpecification());
    }

    public EstimateSpec getEstimate() {
        return new EstimateSpec(this.core.getRegArimaSpecification());
    }

    public X11Spec getX11() {
        return new X11Spec(this.core.getX11Specification(), 0, true);
    }

    public SaBenchmarkingSpec getBenchmarking() {
        return new SaBenchmarkingSpec(this.core.getBenchmarkingSpecification());
    }
}

