% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design.R
\name{designToDescriptives}
\alias{designToDescriptives}
\title{Generate Descriptives}
\usage{
designToDescriptives(design, covariate.scales = NULL)
}
\arguments{
\item{design}{A DesignOptions object}

\item{covariate.scales}{Scale estimates for covariates, a named numeric vector}
}
\value{
Descriptives
}
\description{
Use a design object to generate descriptive statistics that ignore clustering.
Stratum weights are respected if provided (by passing a design arg of
class StratumWeightedDesignOptions). If not provided, stratum weights
default to "Effect of Treatment on Treated" weighting.  That is, when
combining within-stratum averages (which will themselves have been
weighted by unit weights), each stratum receives a weight equal to
the product of the stratum sum of unit weights with the fraction
of clusters within the stratum that were assigned to the treatment
condition.
}
\details{
By default, covariates are scaled by their pooled s.d.s, square roots
of half of their treatment group variances plus half of their control
group variances.  If weights are provided, these are weighted variances.
If descriptives are requested for an unstratified setup, i.e. a 
stratification named \sQuote{\code{--}}, then covariate s.d.s
are calculated against it; otherwise the variances reflect stratification,
and are calculated against the first stratification found.  Either way,
if descriptives are calculated for multiple stratifications, only one
set of covariate s.d.s will have been calculated, and these underlie
standard difference calculations for each of the stratifications.

If a named numeric \code{covariate.scales} argument is provided, any
covariates named in the vector will have their pooled s.d.s taken from
it, rather than from the internal calculation.
}
\keyword{internal}
