/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.plugin.ColorCanvas;
import ij.plugin.ColorGenerator;
import ij.plugin.PlugIn;

public class ColorPicker
extends ImagePlus
implements PlugIn {
    static int id;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getImage(id);
        if (imp != null && imp.getWindow() != null) {
            imp.getWindow().toFront();
            return;
        }
        int colorWidth = 22;
        int colorHeight = 16;
        int columns = 5;
        int rows = 20;
        int width = columns * colorWidth;
        int height = rows * colorHeight;
        ColorGenerator cg = new ColorGenerator(width, height, new int[width * height], this);
        cg.drawColors(colorWidth, colorHeight, columns, rows);
        this.setProcessor("CP", cg);
        id = this.getID();
        this.show();
        IJ.register(ColorPicker.class);
    }

    public void show() {
        if (this.img == null && this.ip != null) {
            this.img = this.ip.createImage();
        }
        ImageWindow.centerNextImage();
        this.win = new ImageWindow(this, new ColorCanvas(this));
        this.draw();
        IJ.showStatus("");
    }
}

