% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HRTList.R
\name{calcAvHRT}
\alias{calcAvHRT}
\alias{calcAvHRT,HRTList-method}
\title{Calculate an avHRT object}
\usage{
calcAvHRT(
  HRTListObj,
  av = mean,
  orTO = "avAfter",
  orTS = "avBefore",
  IL = HRTListObj@IL,
  normIL = c_normIL,
  normHallstrom = TRUE,
  coTO = COTO,
  coTS = COTS,
  coTT = COTT
)

\S4method{calcAvHRT}{HRTList}(
  HRTListObj,
  av = mean,
  orTO = "avAfter",
  orTS = "avBefore",
  IL = HRTListObj@IL,
  normIL = c_normIL,
  normHallstrom = TRUE,
  coTO = COTO,
  coTS = COTS,
  coTT = COTT
)
}
\arguments{
\item{HRTListObj}{HRTList object}

\item{av}{(Function) Type of averaging the VPCSs, either mean or median}

\item{orTO}{(Character) Order in which TO was calculated,
either "avAfter" (assessment of parameter and averaging)
or "avBefore" (averaging of the VPCSs and assessment of parameter)}

\item{orTS}{(Character) Order in which TS was calculated,
either "avAfter" (assessment of parameter and averaging)
or "avBefore" (averaging of the VPCSs and assessment of parameter)}

\item{IL}{(Numeric) The overall arithmetic mean of the interval length of the
measurement to normalise TS}

\item{normIL}{(Numeric) The interval length to which TS should be normalised}

\item{normHallstrom}{(Boolean) Should the normalisation of Hallstrom be used?}

\item{coTO}{(Numeric) Cut-off value for TO}

\item{coTS}{(Numeric) Cut-off value for TS and nTS}

\item{coTT}{(Numeric) Cut-off value for TT}
}
\value{
(avHRT) The avHRT object of the given HRTList
}
\description{
For each index the average of the intervals across all HRTs in the HRTList
is calculated and the averaged HRT returned. The type of averaging, the order
of HRT parameter assessment and interval lengths for normalising TS can be passed.
}
\details{
To eliminate other RR variability TS is commonly assessed after averaging the
VPCSs. TO is commonly first calculated from the single VPCS and then
averaged. (See 'Heart Rate Turbulence: Standards of Measurement,
Physiological Interpretation, and Clinical Use, Axel Bauer et al.,
Journal of the American College of Cardiology, Volume 52, Issue 17,
Pages 1353-1365')
}
\examples{
# You need an HRTList
hrtl <- vectorToHRT(testdataLong, testdataLong_Ann)

# Recalculate the avHRT with different normalisation
calcAvHRT(hrtl, normIL = 1000, normHallstrom = FALSE)

# Recalculate the avHRT based on a different calculation order
calcAvHRT(hrtl, orTO = "avBefore", orTS = "avAfter")

# Set custom parameter cut-offs for the reliability check
## You should keep in mind to give the same cut-offs when calling getResults()
calcAvHRT(hrtl, coTO = 0.022, coTS = 1.42, coTT = 12)

}
