% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{list_dimsmets}
\alias{list_dimsmets}
\title{Lists all the dimensions and metrics for a particular report type}
\usage{
list_dimsmets(reportType = "ga")
}
\arguments{
\item{reportType}{character. Report type. Allowed Values: "ga". Where "ga" corresponds to the Core Reporting API.}
}
\value{
A data.frame contains dimensions and metrics for a particular report type.
\item{id}{Parameter name.}
\item{type}{The type of column: \code{DIMENSION}, \code{METRIC}.}
\item{dataType}{The type of data this column represents: \code{STRING}, \code{INTEGER}, \code{PERCENT}, \code{TIME}, \code{CURRENCY}, \code{FLOAT}.}
\item{group}{The dimensions/metrics group the column belongs to.}
\item{status}{The status of the column: \code{PUBLIC}, \code{DEPRECATED}.}
\item{uiName}{The name/label of the column used in user interfaces (UI).}
\item{description}{The full description of the column.}
\item{allowedInSegments}{Indicates whether the column can be used in the segment query parameter.}
\item{addedInApiVersion}{API version with this param was added.}
\item{replacedBy}{The replacement column to use for a column with a \code{DEPRECATED} status.}
\item{calculation}{Only available for calculated metrics. This shows how the metric is calculated.}
\item{minTemplateIndex}{Only available for templatized columns. This is the minimum index for the column.}
\item{maxTemplateIndex}{Only available for templatized columns. This is the maximum index for the column.}
\item{premiumMinTemplateIndex}{Only available for templatized columns. This is the minimum index for the column for premium properties.}
\item{premiumMaxTemplateIndex}{Only available for templatized columns. This is the maximum index for the column for premium properties.}
}
\description{
This dataset represents all of the dimensions and metrics for the reporting API with their attributes. Attributes returned include UI name, description, segments support, etc.
}
\examples{
\dontrun{
ga_meta <- list_dimsmets("ga")
# a count of parameters types
table(ga_meta$type)
# parameters groups
table(ga_meta$group)
# get a deprecated parameters was replaced by
subset(ga_meta, status == "DEPRECATED", c(id, replacedBy))
# get a calculation metrics
subset(ga_meta, !is.na(calculation), c(id, calculation))
# get a not deprecated metrics from user group
subset(ga_meta, group == "User" & type == "METRIC" & status != "DEPRECATED", id)
# get parameters allowed in segments
subset(ga_meta, allowedInSegments, id)
}

}
\references{
\href{https://developers.google.com/analytics/devguides/reporting/metadata/v3/}{Google Analytics Metadata API}

\href{https://developers.google.com/analytics/devguides/reporting/core/dimsmets}{Core Reporting API - Dimensions & Metrics Reference}
}
\seealso{
\code{\link{shiny_dimsmets}} \code{\link{get_ga}}
}

