% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploads.R
\name{get_upload}
\alias{get_upload}
\title{Uploads}
\usage{
get_upload(accountId, webPropertyId, customDataSourceId, uploadId, token)
}
\arguments{
\item{accountId}{character. Account Id for the upload to retrieve.}

\item{webPropertyId}{character. Web property Id for the upload to retrieve.}

\item{customDataSourceId}{character. Custom data source Id for upload to retrieve.}

\item{uploadId}{character. Upload Id to retrieve.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
The Uploads collection is a set of Upload resources, each of which describes an upload for one of the user's custom data sources. This resource should be used when uploading Dimension Widening data.
\item{id}{A unique ID for this upload.}
\item{kind}{Resource type for Analytics upload.}
\item{accountId}{Account Id to which this upload belongs.}
\item{customDataSourceId}{Custom data source Id to which this data import belongs.}
\item{status}{Upload status. Possible values: PENDING, COMPLETED, FAILED, DELETING, DELETED.}
\item{errors}{Data import errors collection.}
}
\description{
List uploads to which the user has access.
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/uploads}{Management API - Uploads Overview}
}
\seealso{
Other Management API: \code{\link{get_custom_dimension}},
  \code{\link{get_custom_metric}},
  \code{\link{get_experiment}}, \code{\link{get_filter}},
  \code{\link{get_goal}}, \code{\link{get_profile}},
  \code{\link{get_unsampled_report}},
  \code{\link{get_webproperty}},
  \code{\link{list_accounts}},
  \code{\link{list_custom_data_sources}},
  \code{\link{list_custom_dimensions}},
  \code{\link{list_custom_metrics}},
  \code{\link{list_experiments}},
  \code{\link{list_filters}}, \code{\link{list_goals}},
  \code{\link{list_profiles}}, \code{\link{list_segments}},
  \code{\link{list_unsampled_reports}},
  \code{\link{list_uploads}},
  \code{\link{list_webproperties}}
}

