% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ga.R
\name{get_ga}
\alias{get_ga}
\title{Get the Anaytics data from Core Reporting API for a view (profile)}
\usage{
get_ga(profile.id, start.date = "7daysAgo", end.date = "yesterday",
  metrics = "ga:users,ga:sessions,ga:pageviews", dimensions = NULL,
  sort = NULL, filters = NULL, segment = NULL, sampling.level = NULL,
  start.index = NULL, max.results = NULL, fetch.by = NULL, token)
}
\arguments{
\item{profile.id}{integer or character. Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the Analytics view (profile) ID. Can be obtained using the \code{\link{list_profiles}} or via the web interface Google Analytics.}

\item{start.date}{character. Start date for fetching Analytics data. Request can specify the start date formatted as "YYYY-MM-DD" or as a relative date (e.g., "today", "yesterday", or "7daysAgo"). The default value is "7daysAgo".}

\item{end.date}{character. End date for fetching Analytics data. Request can specify the end date formatted as "YYYY-MM-DD" or as a relative date (e.g., "today", "yesterday", or "7daysAgo"). The default value is "yesterday".}

\item{metrics}{character. A comma-separated list of Analytics metrics. E.g., \code{"ga:sessions,ga:pageviews"}. At least one metric must be specified.}

\item{dimensions}{character. A comma-separated list of Analytics dimensions. E.g., \code{"ga:browser,ga:city"}.}

\item{sort}{character. A comma-separated list of dimensions or metrics that determine the sort order for Analytics data.}

\item{filters}{character. A comma-separated list of dimension or metric filters to be applied to Analytics data.}

\item{segment}{character. An Analytics segment to be applied to data. Can be obtained using the \code{\link{list_segments}} or via the web interface Google Analytics.}

\item{sampling.level}{character. The desired sampling level. Allowed values: "DEFAULT", "FASTER", "HIGHER_PRECISION".}

\item{start.index}{integer. An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of entries to include in this feed.}

\item{fetch.by}{character. Split the query by date range. Allowed values: "day", "week", "month", "quarter", "year".}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
A data frame including the Analytics data for a view (profile). Addition information about profile and request query stored in the attributes.
}
\description{
Get the Anaytics data from Core Reporting API for a view (profile)
}
\examples{
\dontrun{
# get token data
authorize()
# get report data
ga_data <- get_ga(XXXXXXX, start.date = "30daysAgo", end.date = "today",
                  metrics = "ga:sessions", dimensions = "ga:source,ga:medium",
                  sort = "-ga:sessions")
}
}
\references{
\href{https://developers.google.com/analytics/devguides/reporting/core/dimsmets}{Core Reporting API - Dimensions & Metrics Reference}

\href{https://developers.google.com/analytics/devguides/reporting/core/v3/reference#q_details}{Core Reporting API - Query Parameter Details}

\href{https://developers.google.com/analytics/devguides/reporting/core/v3/common-queries}{Core Reporting API - Common Queries}

\href{https://ga-dev-tools.appspot.com/explorer/}{Google Analytics Demos & Tools - Query Explorer}
}
\seealso{
\code{\link{authorize}} \code{\link{list_dimsmets}} \code{\link{shiny_dimsmets}}

Other Reporting API: \code{\link{firstdate}};
  \code{\link{get_mcf}}; \code{\link{get_realtime}},
  \code{\link{get_rt}}
}

