/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.services;

import edu.ucsb.cs.jicos.foundation.Department;
import edu.ucsb.cs.jicos.foundation.RemoteExceptionHandler;
import edu.ucsb.cs.jicos.foundation.Service;
import edu.ucsb.cs.jicos.foundation.ServiceImpl;
import edu.ucsb.cs.jicos.foundation.ServiceName;
import edu.ucsb.cs.jicos.services.ClientProfile;
import edu.ucsb.cs.jicos.services.ClientProxy;
import edu.ucsb.cs.jicos.services.ClientToHsp;
import edu.ucsb.cs.jicos.services.ComputeException;
import edu.ucsb.cs.jicos.services.Environment;
import edu.ucsb.cs.jicos.services.Host;
import edu.ucsb.cs.jicos.services.Host2TaskServer;
import edu.ucsb.cs.jicos.services.HspState;
import edu.ucsb.cs.jicos.services.Invoice;
import edu.ucsb.cs.jicos.services.JicosException;
import edu.ucsb.cs.jicos.services.JicosRemoteExceptionHandler;
import edu.ucsb.cs.jicos.services.ProtocolChecker;
import edu.ucsb.cs.jicos.services.Result;
import edu.ucsb.cs.jicos.services.ResultId;
import edu.ucsb.cs.jicos.services.ResultTable;
import edu.ucsb.cs.jicos.services.ServiceTaskStats;
import edu.ucsb.cs.jicos.services.SessionHSP;
import edu.ucsb.cs.jicos.services.SessionInfo;
import edu.ucsb.cs.jicos.services.Task;
import edu.ucsb.cs.jicos.services.TaskId;
import edu.ucsb.cs.jicos.services.TaskServer;
import edu.ucsb.cs.jicos.services.TaskServerProxy;
import edu.ucsb.cs.jicos.services.TaskServerServiceInfo;
import edu.ucsb.cs.jicos.services.TopologyManager;
import edu.ucsb.cs.jicos.services.commands.LoginClient;
import edu.ucsb.cs.jicos.services.commands.LogoutClient;
import edu.ucsb.cs.jicos.services.commands.Spawn;
import edu.ucsb.cs.jicos.utilities.Qu;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;

public final class Hsp
extends ServiceImpl
implements ClientToHsp {
    static final int COMPUTE = 0;
    static final int GETRESULT = 1;
    static final int LOGIN = 2;
    static final int LOGOUT = 3;
    static final int SETCOMPUTATION = 4;
    private static final Class[][] command2DepartmentArray;
    private static final RemoteExceptionHandler remoteExceptionHandler;
    private Department[] departments = new Department[]{ServiceImpl.ASAP_DEPARTMENT};
    private int nTaskServers;
    private int nHosts;
    private TopologyManager topologyManager = new TopologyManager(this.proxyManager());
    private List taskServerTree = new ArrayList();
    private Service rootTaskServer;
    private TaskServerProxy rootTaskServerProxy;
    private Host2TaskServer host2TaskServer = new Host2TaskServer();
    private ClientProxy clientProxy;
    private Qu clientQ = new Qu();
    private Qu loginQ = new Qu();
    private ProtocolChecker protocolChecker = new ProtocolChecker();
    private SessionHSP session;
    private short computationId;
    private TaskId currentTask;
    private Object value;
    private ResultTable resultTable = new ResultTable();
    private ServiceTaskStats hspTaskStats = new ServiceTaskStats(this.serviceName());
    private Invoice invoice;
    private int pendingResults;
    private boolean isJicosException;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$AddServiceTaskStats;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$GetServiceName;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$GetTaskServer;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$PutResult;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$UpdateTaskServerState;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$Hsp;

    public Hsp() throws RemoteException {
        super(command2DepartmentArray, "HostingServiceProvider");
        super.setService(this);
        super.setDepartments(this.departments);
        System.out.println("Hsp: Constructed.");
    }

    public synchronized void addServiceTaskStats(List list) {
        this.hspTaskStats.addAll(list);
        this.notify();
    }

    private void check4Exception(Object object) throws ComputeException, JicosException {
        String string = "";
        if (object instanceof Exception || this.isJicosException) {
            try {
                this.logout();
            }
            catch (Exception exception) {
                string = string + "Logout failed. \n";
            }
            Exception exception = (Exception)object;
            System.out.println("Hsp: check4Exception: Exception detected.");
            exception.printStackTrace();
            string = string + exception.toString();
            if (this.isJicosException) {
                this.isJicosException = false;
                JicosException jicosException = new JicosException(string);
                jicosException.setStackTrace(exception.getStackTrace());
                throw jicosException;
            }
            ComputeException computeException = new ComputeException(string);
            computeException.setStackTrace(exception.getStackTrace());
            throw computeException;
        }
    }

    public synchronized Object compute(Task task) throws ComputeException, JicosException, RemoteException {
        String string = this.protocolChecker.check(2);
        if (string != null) {
            throw new IllegalStateException(string);
        }
        ++this.pendingResults;
        this.spawnTask(task);
        this.currentTask = task.getTaskId();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.check4Exception(this.value);
        this.currentTask = null;
        return this.value;
    }

    public void exceptionHandler(Exception exception) {
        Result result = new Result(null, exception, 0L);
        this.putResult(null, result);
    }

    public int getPendingResults() {
        return this.pendingResults;
    }

    public ProtocolChecker getProtocolChecker() {
        return this.protocolChecker;
    }

    public Result getResult() throws ComputeException, JicosException, RemoteException {
        System.out.println("Hsp.getResult: checking protocol.");
        String string = this.protocolChecker.check(4);
        if (string != null) {
            throw new IllegalStateException(string);
        }
        Result result = this.resultTable.remove();
        System.out.println("Hsp.getResult: cpt: " + result.getCriticalPathTime());
        Object object = result.getValue();
        this.check4Exception(object);
        return result;
    }

    public synchronized SessionInfo getSessionInfo() {
        return this.session == null ? null : this.session.getSessionInfo();
    }

    public HspState getState() {
        return new HspState(this.serviceName(), this.clientQ, this.nHosts, this.nTaskServers);
    }

    public synchronized ServiceName getTaskServer() {
        while (this.rootTaskServer == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.host2TaskServer.get();
    }

    private void initClient(ServiceName serviceName, ClientProfile clientProfile, Environment environment) {
        String string = this.protocolChecker.check(0);
        if (string != null) {
            throw new IllegalStateException(string);
        }
        if (environment == null) {
            string = "Login error: Environment parameter may not be null.";
            throw new IllegalArgumentException(string);
        }
        this.currentTask = null;
        this.value = null;
        this.resultTable.clear();
        this.hspTaskStats.clear();
        this.invoice = null;
        this.session = new SessionHSP(environment);
        this.clientProxy = new ClientProxy(serviceName, this, remoteExceptionHandler);
        if (this.rootTaskServer != null) {
            LoginClient loginClient = new LoginClient(this.session.getSessionInfo());
            this.rootTaskServerProxy.execute(loginClient);
        } else {
            System.out.println("Hsp: login: rootTaskServer: == null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(ServiceName serviceName, ClientProfile clientProfile, Environment environment) {
        Hsp hsp = this;
        synchronized (hsp) {
            this.clientQ.add(clientProfile);
            this.loginQ.add(serviceName);
            if (this.loginQ.size() <= 1) {
                this.initClient(serviceName, clientProfile, environment);
                return;
            }
        }
        ServiceName serviceName2 = serviceName;
        synchronized (serviceName2) {
            try {
                serviceName.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Hsp hsp2 = this;
        synchronized (hsp2) {
            this.initClient(serviceName, clientProfile, environment);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Invoice logout() throws RemoteException {
        String string = this.protocolChecker.check(1);
        if (string != null) {
            throw new IllegalStateException(string);
        }
        if (this.invoice != null) {
            this.session = null;
            return this.invoice;
        }
        if (this.session == null) {
            return null;
        }
        long l = System.currentTimeMillis();
        LogoutClient logoutClient = new LogoutClient();
        this.rootTaskServerProxy.execute(logoutClient);
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l2 = this.session.getStartTime();
        this.session = null;
        this.value = null;
        this.resultTable.clear();
        this.clientProxy.kill();
        this.clientProxy = null;
        this.clientQ.remove();
        this.loginQ.remove();
        if (this.loginQ.size() > 0) {
            ServiceName serviceName;
            ServiceName serviceName2 = serviceName = (ServiceName)this.loginQ.get();
            synchronized (serviceName2) {
                serviceName.notify();
            }
        }
        System.out.println("HSP.logout: logged out client.");
        return new Invoice(l2, l, this.hspTaskStats);
    }

    public synchronized void putResult(TaskId taskId, Result result) {
        if (taskId == null) {
            this.isJicosException = true;
        }
        if (this.currentTask != null && (taskId == null || taskId.computationEquals(this.currentTask))) {
            this.value = result.getValue();
            this.notify();
        } else {
            ResultId resultId = new ResultId(taskId);
            this.resultTable.put(resultId, result);
        }
        --this.pendingResults;
    }

    public synchronized TaskServerServiceInfo[] registerTaskServer(ServiceName serviceName) {
        if (!$assertionsDisabled && serviceName == null) {
            throw new AssertionError();
        }
        System.out.println("Hsp.registerTaskServer: Registering " + serviceName);
        TaskServerServiceInfo taskServerServiceInfo = new TaskServerServiceInfo(serviceName);
        TaskServerServiceInfo[] taskServerServiceInfoArray = this.topologyManager.add(taskServerServiceInfo);
        Service service = serviceName.service();
        TaskServerProxy taskServerProxy = new TaskServerProxy(serviceName, this, remoteExceptionHandler);
        this.addProxy(serviceName, taskServerProxy);
        this.host2TaskServer.add(serviceName);
        if (this.rootTaskServer == null) {
            this.rootTaskServer = service;
            this.rootTaskServerProxy = taskServerProxy;
            this.notifyAll();
        }
        ++this.nTaskServers;
        return taskServerServiceInfoArray;
    }

    public synchronized ResultId setComputation(Task task) {
        String string = this.protocolChecker.check(3);
        if (string != null) {
            throw new IllegalStateException(string);
        }
        ++this.pendingResults;
        this.spawnTask(task);
        return new ResultId(task.getTaskId());
    }

    private void spawnTask(Task task) {
        short s = this.computationId;
        this.computationId = (short)(s + 1);
        task.init(this.session.getStartTime(), s);
        task.setTaskServer(this.rootTaskServer);
        Spawn spawn = new Spawn(task);
        this.rootTaskServerProxy.execute(spawn);
    }

    public void updateTaskServerState(int n) {
        this.nHosts += n;
    }

    public static void main(String[] stringArray) throws UnknownHostException, AlreadyBoundException, RemoteException, Exception {
        System.setSecurityManager(new RMISecurityManager());
        Registry registry = LocateRegistry.createRegistry(5237);
        Hsp hsp = new Hsp();
        registry.bind("Service", hsp);
        System.out.println("Hsp: Ready.");
        int n = 0;
        int n2 = 0;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        if (stringArray.length > 1) {
            n2 = Integer.parseInt(stringArray[1]);
        }
        int n3 = 0;
        while (n3 < n) {
            new TaskServer(hsp, "Hsp taskserver " + n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            new Host(hsp, "Hsp host " + n4, null);
            ++n4;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$ucsb$cs$jicos$services$Hsp == null ? (class$edu$ucsb$cs$jicos$services$Hsp = Hsp.class$("edu.ucsb.cs.jicos.services.Hsp")) : class$edu$ucsb$cs$jicos$services$Hsp).desiredAssertionStatus();
        command2DepartmentArray = new Class[][]{{class$edu$ucsb$cs$jicos$services$commands$AddServiceTaskStats == null ? (class$edu$ucsb$cs$jicos$services$commands$AddServiceTaskStats = Hsp.class$("edu.ucsb.cs.jicos.services.commands.AddServiceTaskStats")) : class$edu$ucsb$cs$jicos$services$commands$AddServiceTaskStats, class$edu$ucsb$cs$jicos$services$commands$GetServiceName == null ? (class$edu$ucsb$cs$jicos$services$commands$GetServiceName = Hsp.class$("edu.ucsb.cs.jicos.services.commands.GetServiceName")) : class$edu$ucsb$cs$jicos$services$commands$GetServiceName, class$edu$ucsb$cs$jicos$services$commands$GetTaskServer == null ? (class$edu$ucsb$cs$jicos$services$commands$GetTaskServer = Hsp.class$("edu.ucsb.cs.jicos.services.commands.GetTaskServer")) : class$edu$ucsb$cs$jicos$services$commands$GetTaskServer, class$edu$ucsb$cs$jicos$services$commands$PutResult == null ? (class$edu$ucsb$cs$jicos$services$commands$PutResult = Hsp.class$("edu.ucsb.cs.jicos.services.commands.PutResult")) : class$edu$ucsb$cs$jicos$services$commands$PutResult, class$edu$ucsb$cs$jicos$services$commands$UpdateTaskServerState == null ? (class$edu$ucsb$cs$jicos$services$commands$UpdateTaskServerState = Hsp.class$("edu.ucsb.cs.jicos.services.commands.UpdateTaskServerState")) : class$edu$ucsb$cs$jicos$services$commands$UpdateTaskServerState}};
        remoteExceptionHandler = new JicosRemoteExceptionHandler();
    }
}

