/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.graphedgeselection;

import freak.core.control.Schedule;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.module.fitness.graphedgeselection.AbstractMSTFitnessFunction;
import freak.module.searchspace.GraphEdgeSelection;
import freak.module.searchspace.GraphEdgeSelectionGenotype;

public class MSTWithComponentAndEdgeCount
extends AbstractMSTFitnessFunction {
    public MSTWithComponentAndEdgeCount(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype gen) {
        GraphEdgeSelectionGenotype genotype = (GraphEdgeSelectionGenotype)gen;
        GraphEdgeSelection.Graph graph = genotype.getGraph();
        int numOfComponents = graph.numOfConnectedComponentsForSelectedEdges(genotype);
        int numOfEdges = graph.getNumberOfSelectedEdges(genotype);
        int edgeWeightSum = graph.getSumOfWeightsOfAllSelectedEdges(genotype);
        int n = graph.getNumberOfNodes();
        int wmax = graph.getMaxEdgeWeight();
        int wub = wmax * n * n;
        return -((numOfComponents - 1) * wub * wub + (numOfEdges - (n - 1)) * wub + edgeWeightSum);
    }

    public String getDescription() {
        return " The Individual passed represents a subset E' of the set  of all edges in a graph.  The value returned is the sum of the number of connected components in the graph wrt E',  the number of edges in E', and the sum of the weight of all edges in E'.";
    }

    public String getName() {
        return "MST with components and edge count";
    }

    public int compareIndividuals(Individual ind1, Individual ind2) {
        int ew2;
        int edg2;
        int cc2;
        if (ind1 == ind2) {
            return 0;
        }
        GraphEdgeSelectionGenotype gen1 = (GraphEdgeSelectionGenotype)ind1.getPhenotype();
        GraphEdgeSelectionGenotype gen2 = (GraphEdgeSelectionGenotype)ind2.getPhenotype();
        GraphEdgeSelection.Graph graph = gen1.getGraph();
        int cc1 = graph.numOfConnectedComponentsForSelectedEdges(gen1);
        if (cc1 < (cc2 = graph.numOfConnectedComponentsForSelectedEdges(gen2))) {
            return 1;
        }
        if (cc1 > cc2) {
            return -1;
        }
        int edg1 = graph.getNumberOfSelectedEdges(gen1);
        if (edg1 < (edg2 = graph.getNumberOfSelectedEdges(gen2))) {
            return 1;
        }
        if (edg1 > edg2) {
            return -1;
        }
        int ew1 = graph.getSumOfWeightsOfAllSelectedEdges(gen1);
        if (ew1 < (ew2 = graph.getSumOfWeightsOfAllSelectedEdges(gen2))) {
            return 1;
        }
        if (ew1 == ew2) {
            return 0;
        }
        return -1;
    }
}

