/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.graphedgeselection;

import freak.core.control.Schedule;
import freak.core.population.Genotype;
import freak.module.fitness.graphedgeselection.AbstractMSTFitnessFunction;
import freak.module.searchspace.GraphEdgeSelection;
import freak.module.searchspace.GraphEdgeSelectionGenotype;

public class MSTOnSpanningTrees
extends AbstractMSTFitnessFunction {
    public MSTOnSpanningTrees(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype gen) {
        GraphEdgeSelectionGenotype genotype = (GraphEdgeSelectionGenotype)gen;
        GraphEdgeSelection.Graph graph = genotype.getGraph();
        return -graph.getSumOfWeightsOfAllSelectedEdges(genotype);
    }

    public String getName() {
        return "MST on Spanning Trees";
    }

    public String getDescription() {
        return "This function just sums up the edge weights to find a minimal spanning tree. It is only for use if every individual represents a spanning tree itself (like with Pr\u00b8fer numbers). Calculations of connected components are not needed here as they are always 1.";
    }
}

