/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.generalstring;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.fitness.AbstractStaticMultiObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.module.fitness.generalstring.SSSPUniformInstance;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;
import java.util.Iterator;

public class SSSPMultiObjective
extends AbstractStaticMultiObjectiveFitnessFunction
implements RunEventListener,
Configurable {
    private SSSPUniformInstance instance = null;
    private int maxWeight = 10;
    private boolean instanceCreated = false;

    public SSSPMultiObjective(Schedule schedule) {
        super(schedule);
        GeneralString sp = (GeneralString)this.getSchedule().getGenotypeSearchSpace();
        this.instance = new SSSPUniformInstance(sp.getDimension() + 1, schedule.getRandomElement(), 10);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        GeneralString sp = (GeneralString)this.getSchedule().getGenotypeSearchSpace();
        if (sp.getPropertyNumberOfChars() != sp.getDimension() + 1) {
            throw new UnsupportedEnvironmentException("The number of characters must equals the dimension+1.");
        }
    }

    protected double[] evaluate(Genotype genotype) {
        int[] gt = ((GeneralStringGenotype)genotype).getIntArray();
        try {
            double[] result = this.instance.getMultiFitness(gt);
            int i = 0;
            while (i < result.length) {
                result[i] = -result[i];
                ++i;
            }
            return result;
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Fehler mit den SSSP-Dimensionen.");
        }
    }

    public int getDimensionOfObjectiveSpace() {
        GeneralString sp = (GeneralString)this.getSchedule().getGenotypeSearchSpace();
        return sp.getDimension();
    }

    public boolean containsParetoFront(IndividualList list) throws UnsupportedOperationException {
        if (!this.instanceCreated) {
            return false;
        }
        Iterator it = list.iterator();
        double[] opt = this.instance.getOptimum();
        while (it.hasNext()) {
            Individual ind = (Individual)it.next();
            double[] fit = this.evaluate(ind, null);
            int i = 0;
            while (i < fit.length) {
                if (fit[i] != -opt[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public double[] getOptimalFitnessValue() throws UnsupportedOperationException {
        if (!this.instanceCreated) {
            return new double[]{0.0};
        }
        double[] result = this.instance.getOptimum();
        int i = 0;
        while (i < result.length) {
            result[i] = -result[i];
            ++i;
        }
        return result;
    }

    public String getName() {
        return "Multi Objective SSSP";
    }

    public String getDescription() {
        return "This fitness function represents the single source shortest path problem. Each entry in the distance matrix is choosen uniformly at random from the set {1,...,maxDistance}. The components of the fitness vector are the path lengths represented by the search point.";
    }

    public void runStarted(RunEvent evt) {
        this.instance.setRandomElement(this.getSchedule().getRandomElement());
        this.instance.nextInstance();
        this.instanceCreated = true;
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }

    public Integer getPropertyMaxDistance() {
        return new Integer(this.maxWeight);
    }

    public void setPropertyMaxDistance(Integer i) {
        this.maxWeight = i;
        this.instance.setMaxDistance(this.maxWeight);
    }
}

