/*
 * Decompiled with CFR 0.152.
 */
package freak.core.graph;

import freak.core.graph.FreakPort;
import freak.core.graph.HasFloatingNumberOfInPorts;
import freak.core.graph.HasFloatingNumberOfOutPorts;
import freak.core.graph.InPort;
import freak.core.graph.Initialization;
import freak.core.graph.Mutation;
import freak.core.graph.Operator;
import freak.core.graph.OutPort;
import freak.core.graph.Port;
import freak.core.graph.Recombination;
import freak.core.graph.Selection;
import freak.core.graph.Split;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.border.BevelBorder;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

public class OperatorGraphCell
extends DefaultGraphCell {
    protected Map portMapper;
    private Color defaultColor = new Color(192, 255, 255);
    private Color selectionColor = new Color(255, 220, 168);
    private Color mutationColor = new Color(255, 192, 192);
    private Color splitColor = new Color(255, 255, 192);
    private Color recombinationColor = new Color(192, 255, 192);
    private Color initializationColor = new Color(192, 192, 255);

    public OperatorGraphCell(Operator operator) {
        super(operator);
        FreakPort freakPort;
        this.portMapper = new HashMap();
        GraphConstants.setBorder(this.attributes, new BevelBorder(0));
        Color color = this.defaultColor;
        if (operator instanceof Selection) {
            color = this.selectionColor;
        } else if (operator instanceof Mutation) {
            color = this.mutationColor;
        } else if (operator instanceof Split) {
            color = this.splitColor;
        } else if (operator instanceof Recombination) {
            color = this.recombinationColor;
        } else if (operator instanceof Initialization) {
            color = this.initializationColor;
        }
        GraphConstants.setBackground(this.attributes, color);
        GraphConstants.setOpaque(this.attributes, true);
        boolean hasFreeInPort = false;
        int i = 0;
        while (i < operator.getNumberOfInPorts()) {
            InPort inPort = operator.getInPort(i);
            if (inPort.getNumberOfPartners() == 0) {
                hasFreeInPort = true;
            }
            freakPort = new FreakPort(inPort, this);
            super.add(freakPort);
            this.portMapper.put(inPort, freakPort);
            ++i;
        }
        if (operator instanceof HasFloatingNumberOfInPorts && !hasFreeInPort) {
            ((HasFloatingNumberOfInPorts)((Object)operator)).addInPort();
            InPort newPort = operator.getInPort(operator.getNumberOfInPorts() - 1);
            freakPort = new FreakPort(newPort, this);
            super.add(freakPort);
            this.portMapper.put(newPort, freakPort);
        }
        boolean hasFreeOutPort = false;
        int i2 = 0;
        while (i2 < operator.getNumberOfOutPorts()) {
            OutPort outPort = operator.getOutPort(i2);
            if (outPort.getNumberOfPartners() == 0) {
                hasFreeOutPort = true;
            }
            freakPort = new FreakPort(outPort, this);
            super.add(freakPort);
            this.portMapper.put(outPort, freakPort);
            ++i2;
        }
        if (operator instanceof HasFloatingNumberOfOutPorts && !hasFreeOutPort) {
            ((HasFloatingNumberOfOutPorts)((Object)operator)).addOutPort();
            OutPort newPort = operator.getOutPort(operator.getNumberOfOutPorts() - 1);
            freakPort = new FreakPort(newPort, this);
            super.add(freakPort);
            this.portMapper.put(newPort, freakPort);
        }
    }

    public Operator getOperator() {
        return (Operator)this.getUserObject();
    }

    public Iterator getPortIterator() {
        return Collections.unmodifiableCollection(this.portMapper.values()).iterator();
    }

    public Map changeAttributes(Map map) {
        Map changed = super.changeAttributes(map);
        if (map.containsKey("bounds")) {
            this.adjustPortPositions();
        }
        return changed;
    }

    public void adjustPortPositions() {
        Iterator iter = this.getPortIterator();
        while (iter.hasNext()) {
            FreakPort port = (FreakPort)iter.next();
            port.arrange();
        }
    }

    void portAdded(Port port) {
        if (!this.portMapper.containsKey(port)) {
            FreakPort newPort = new FreakPort(port, this);
            this.portMapper.put(port, newPort);
            super.add(newPort);
        }
        this.adjustPortPositions();
    }

    void portRemoved(Port port) {
        FreakPort freakPort = (FreakPort)this.portMapper.get(port);
        this.portMapper.remove(port);
        super.remove(freakPort);
        this.adjustPortPositions();
    }

    void portsExchanged(Port port1, Port port2) {
        FreakPort xPort = (FreakPort)this.portMapper.get(port1);
        FreakPort yPort = (FreakPort)this.portMapper.get(port2);
        int x = this.getChildren().indexOf(xPort);
        int y = this.getChildren().indexOf(yPort);
        this.getChildren().set(x, yPort);
        this.getChildren().set(y, xPort);
        this.adjustPortPositions();
    }

    public void refreshFloatingPorts() {
        Operator operator = this.getOperator();
        boolean hasFreeInPort = false;
        int i = 0;
        while (i < operator.getNumberOfInPorts()) {
            InPort inPort = operator.getInPort(i);
            if (inPort.getNumberOfPartners() == 0) {
                hasFreeInPort = true;
            }
            ++i;
        }
        if (operator instanceof HasFloatingNumberOfInPorts && !hasFreeInPort) {
            ((HasFloatingNumberOfInPorts)((Object)operator)).addInPort();
        }
        boolean hasFreeOutPort = false;
        int i2 = 0;
        while (i2 < operator.getNumberOfOutPorts()) {
            OutPort outPort = operator.getOutPort(i2);
            if (outPort.getNumberOfPartners() == 0) {
                hasFreeOutPort = true;
            }
            ++i2;
        }
        if (operator instanceof HasFloatingNumberOfOutPorts && !hasFreeOutPort) {
            ((HasFloatingNumberOfOutPorts)((Object)operator)).addOutPort();
        }
        this.adjustPortPositions();
    }

    public void setAttributes(Map attributes) {
        super.setAttributes(attributes);
    }
}

