/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset.math.matrix.view;

import freak.module.fitness.pointset.math.matrix.Matrix;
import freak.module.fitness.pointset.math.matrix.view.NormalView;

public abstract class SimpleView {
    Matrix m_kMat;

    public abstract int getCol();

    public abstract int getRow();

    public abstract void set(int var1, int var2, double var3) throws Exception;

    public abstract double get(int var1, int var2) throws Exception;

    public boolean sameModel(SimpleView pView) {
        return this.m_kMat == pView.m_kMat;
    }

    public Matrix getMatrix() {
        return this.m_kMat;
    }

    public void setMatrix(Matrix pMat) {
        this.m_kMat = pMat;
    }

    public Matrix copyModelFromView() {
        Matrix cpy = new Matrix(this.getRow(), this.getCol());
        NormalView nv = new NormalView(cpy);
        int r = 0;
        while (r < this.getRow()) {
            int c = 0;
            while (c < this.getCol()) {
                try {
                    nv.set(r, c, this.get(r, c));
                }
                catch (Exception e) {
                    throw new Error("Unespected Error in SimpleView.copyModelFromView()");
                }
                ++c;
            }
            ++r;
        }
        return cpy;
    }

    public boolean validRowIndex(int rowIndex) {
        return -1 < rowIndex && rowIndex < this.getRow();
    }

    public boolean validColIndex(int colIndex) {
        return -1 < colIndex && colIndex < this.getCol();
    }

    public boolean isSquared() {
        return this.m_kMat.isSquared();
    }

    public String toString() {
        String result = "";
        try {
            int r = 0;
            while (r < this.getRow()) {
                result = String.valueOf(result) + "(";
                int c = 0;
                while (c < this.getCol() - 1) {
                    result = String.valueOf(result) + this.get(r, c) + ", ";
                    ++c;
                }
                result = String.valueOf(result) + this.get(r, this.getCol() - 1) + ")\n";
                ++r;
            }
        }
        catch (Exception e) {
            throw new Error("Ein unerwarteter Fehler in RowView to String");
        }
        return result;
    }
}

