% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R
\name{plotAUCvsCombinations}
\alias{plotAUCvsCombinations}
\title{Plotting the average AUC as a function of the number of combinations}
\usage{
plotAUCvsCombinations(auc_values, num_of_variables, num_of_combinations)
}
\arguments{
\item{auc_values}{an array with the auc values to plot}

\item{num_of_variables}{the k dimension of each combination}

\item{num_of_combinations}{the number of k combinations of the set of the input variables}
}
\description{
This function allows to plot the average AUC as a function of the number k-combinations of the n input
variables. If n is the number of input variables, the number of k-combinations of those variables is equal to
\eqn{n!/k!(n!-k!)}. Each of these combinations contains the indexes of the input variables selected. For each 
combination we can extract a dataset, build a random forest model and perform a cross-validation. We can describe
the performance of each cross-validated model with an 'average' ROC curve and its AUC. The collected auc values
for each combination (dataset) are used by the function to build a diagram of the AUC as a function 
of the number of combinations
}
\author{
Piergiorgio Palla
}

