/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents.eventlist;

import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedblackTree
implements EventList {
    private TreeMap<Event, Node> tree = new TreeMap(new EventComparator());
    private static Node free = null;
    private int modCount = 0;

    @Override
    public void clear() {
        Iterator<Node> iterator = this.tree.values().iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            node.events.clear();
            iterator.remove();
            node.nextNode = free;
            free = node;
        }
        ++this.modCount;
    }

    @Override
    public void add(Event event) {
        Node node = this.tree.get(event);
        if (node != null) {
            node.events.add(event);
        } else {
            this.tree.put(new EventMapKey(event), this.newNode(event));
        }
        ++this.modCount;
    }

    @Override
    public void addFirst(Event event) {
        event.setTime(Sim.time());
        Node node = this.tree.get(event);
        if (node != null) {
            node.events.add(event);
        } else {
            this.tree.put(new EventMapKey(event), this.newNode(event));
        }
        ++this.modCount;
    }

    @Override
    public void addBefore(Event event, Event event2) {
        Node node = this.tree.get(event2);
        if (node == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        event.setTime(event2.time());
        node.addBefore(event, event2);
        ++this.modCount;
    }

    @Override
    public void addAfter(Event event, Event event2) {
        Node node = this.tree.get(event2);
        if (node == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        event.setTime(event2.time());
        node.addAfter(event, event2);
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        return this.isEmpty() ? null : this.tree.get((Object)this.tree.firstKey()).events.get(0);
    }

    @Override
    public Event getFirstOfClass(String string) {
        for (Node node : this.tree.values()) {
            Event event = node.getFirstOfClass(string);
            if (event == null) continue;
            return event;
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> clazz) {
        for (Node node : this.tree.values()) {
            E e = node.getFirstOfClass(clazz);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Override
    public boolean remove(Event event) {
        Node node = this.tree.get(event);
        if (node == null) {
            return false;
        }
        if (node.remove(event)) {
            this.tree.remove(event);
            node.nextNode = free;
            free = node;
        }
        ++this.modCount;
        return true;
    }

    @Override
    public Event removeFirst() {
        if (this.tree.isEmpty()) {
            return null;
        }
        Event event = this.tree.firstKey();
        Node node = this.tree.get(event);
        Event event2 = node.events.get(0);
        node.events.remove(0);
        if (node.events.isEmpty()) {
            this.tree.remove(event);
            node.nextNode = free;
            free = node;
        }
        ++this.modCount;
        return event2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Contents of the event list RedblackTree :");
        for (Node node : this.tree.values()) {
            for (Event event : node.events) {
                stringBuffer.append("\n" + PrintfFormat.g(8, 4, event.time()) + " : " + event.toString());
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new RBItr();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    private Node newNode(Event event) {
        if (free == null) {
            return new Node(event);
        }
        Node node = free;
        free = RedblackTree.free.nextNode;
        node.events.add(event);
        return node;
    }

    private class EventMapKey
    extends Event {
        public EventMapKey(Event event) {
            this.eventTime = event.time();
        }

        public void actions() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RBItr
    implements ListIterator<Event> {
        private int expectedModCount;
        private Node prevNode;
        private Node nextNode;
        private int prevNodeIndex;
        private int nextNodeIndex;
        private int nextIndex;

        RBItr() {
            this.expectedModCount = RedblackTree.this.modCount;
            this.prevNode = null;
            this.nextNode = RedblackTree.this.tree.isEmpty() ? null : (Node)RedblackTree.this.tree.get(RedblackTree.this.tree.firstKey());
            this.prevNodeIndex = 0;
            this.nextNodeIndex = 0;
            this.nextIndex = 0;
            Iterator iterator = RedblackTree.this.tree.values().iterator();
            Node node = null;
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                node2.prevNode = node;
                if (node != null) {
                    node.nextNode = node2;
                }
                node2.nextNode = null;
                node = node2;
            }
        }

        @Override
        public void add(Event event) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (RedblackTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextNode != null && this.nextNodeIndex < this.nextNode.events.size();
        }

        @Override
        public boolean hasPrevious() {
            if (RedblackTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.prevNode != null && this.prevNodeIndex >= 0;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event event = this.nextNode.events.get(this.nextNodeIndex);
            this.prevNode = this.nextNode;
            this.prevNodeIndex = this.nextNodeIndex++;
            if (this.nextNodeIndex >= this.nextNode.events.size()) {
                this.nextNode = this.nextNode.nextNode;
                this.nextNodeIndex = 0;
            }
            return event;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event event = this.prevNode.events.get(this.prevNodeIndex);
            this.nextNode = this.prevNode;
            this.nextNodeIndex = this.prevNodeIndex--;
            if (this.prevNodeIndex < 0) {
                this.prevNode = this.prevNode.prevNode;
                if (this.prevNode != null) {
                    this.prevNodeIndex = this.prevNode.events.size() - 1;
                }
            }
            return event;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Event event) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventComparator
    implements Comparator<Event> {
        private EventComparator() {
        }

        @Override
        public int compare(Event event, Event event2) {
            double d;
            double d2 = event.time();
            if (d2 > (d = event2.time())) {
                return 1;
            }
            if (d2 == d) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean equals(Object object) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node {
        public Node prevNode = null;
        public Node nextNode = null;
        public List<Event> events = new LinkedList<Event>();

        public Node(Event event) {
            this.events.add(event);
        }

        public void addAfter(Event event, Event event2) {
            ListIterator<Event> listIterator = this.events.listIterator();
            while (listIterator.hasNext()) {
                Event event3 = listIterator.next();
                if (event3 != event2) continue;
                listIterator.add(event);
                return;
            }
            throw new IllegalArgumentException("Event not in node.");
        }

        public void addBefore(Event event, Event event2) {
            ListIterator<Event> listIterator = this.events.listIterator();
            while (listIterator.hasNext()) {
                Event event3 = listIterator.next();
                if (event3 != event2) continue;
                listIterator.previous();
                listIterator.add(event);
                return;
            }
            throw new IllegalArgumentException("Event not in node.");
        }

        public Event getFirstOfClass(String string) {
            for (Event event : this.events) {
                if (!event.getClass().getName().equals(string)) continue;
                return event;
            }
            return null;
        }

        public <E extends Event> E getFirstOfClass(Class<E> clazz) {
            for (Event event : this.events) {
                if (event.getClass() != clazz) continue;
                return (E)event;
            }
            return null;
        }

        public boolean remove(Event event) {
            Iterator<Event> iterator = this.events.iterator();
            while (iterator.hasNext()) {
                Event event2 = iterator.next();
                if (event2 != event) continue;
                iterator.remove();
                return this.events.isEmpty();
            }
            throw new IllegalArgumentException("Event not in node.");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            Iterator<Event> iterator = this.events.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(iterator.next());
            }
            return stringBuffer.toString();
        }
    }
}

