% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-metadata-write.R
\name{redcap_metadata_write}
\alias{redcap_metadata_write}
\title{Import metadata of a REDCap project}
\usage{
redcap_metadata_write(
  ds,
  redcap_uri,
  token,
  verbose = TRUE,
  config_options = NULL
)
}
\arguments{
\item{ds}{The \code{\link[base:data.frame]{base::data.frame()}} to be imported into the REDCap project.
Required.}

\item{redcap_uri}{The URI (uniform resource identifier) of the REDCap
project.  Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  The verbose output might contain
sensitive information (\emph{e.g.} PHI), so turn this off if the output might
be visible somewhere public. Optional.}

\item{config_options}{A list of options to pass to \code{\link[httr:POST]{httr::POST()}} method
in the 'httr' package.  See the details in \code{\link[=redcap_read_oneshot]{redcap_read_oneshot()}} Optional.}
}
\value{
Currently, a list is returned with the following elements:
\itemize{
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_code}: The
\href{http://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status code}
of the operation.
\item \code{outcome_message}: A human readable string indicating the operation's
outcome.
\item \code{field_count}: Number of fields imported.
\item \code{elapsed_seconds}: The duration of the function.
\item \code{raw_text}: If an operation is NOT successful, the text returned by
REDCap.  If an operation is successful, the \code{raw_text} is returned as an
empty string to save RAM.
}
}
\description{
Import metadata (\emph{i.e.}, data dictionary)
into a project. Because of this method's destructive nature,
it works for only projects in Development status.
}
\examples{
\dontrun{
# Please don't run this example without changing the token to
# point to your server.  It could interfere with our testing suite.
uri            <- "https://bbmc.ouhsc.edu/redcap/api/"
token          <- "457C24AB91B7FCF5B1A7DA67E70E24C7"

# Read in the dictionary in R's memory from a csv file.
ds_to_write <-
  readr::read_csv(
    file = system.file(
      "test-data/project-simple/simple-metadata.csv",
      package = "REDCapR"
    ),
    col_types = readr::cols(.default = readr::col_character())
  )
ds_to_write

# Import the dictionary into the REDCap project
REDCapR::redcap_metadata_write(
  ds          = ds_to_write,
  redcap_uri  = uri,
  token       = token
)
}

}
\references{
The official documentation can be found on the 'API Help Page'
and 'API Examples' pages on the REDCap wiki.
If you do not have an account for the wiki, please ask your campus REDCap
administrator to send you the static material.
}
\author{
Will Beasley
}
