% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RDS.compare.proportions.R
\name{RDS.compare.two.proportions}
\alias{RDS.compare.two.proportions}
\title{Compares the rates of two variables against one another.}
\usage{
RDS.compare.two.proportions(data, variables, confidence.level = 0.95,
  number.of.bootstrap.samples = 5000, plot = FALSE, seed = 1)
}
\arguments{
\item{data}{An object of class \code{rds.interval.estimates.list} with attribute \cr
\code{variables} containing a character vector of names of objects of class\cr
\code{rds.interval.estimate}.}

\item{variables}{A character vector of column names to select from \code{data}.}

\item{confidence.level}{The confidence level for the confidence intervals. The default is 0.95 for 95\%.}

\item{number.of.bootstrap.samples}{The number of Monte Carlo draws to determine the null distribution of the likelihood
ratio statistic.}

\item{plot}{Logical, if TRUE then a plot is produces of the null distribution of the likelihood
ratio statistic with the observed statistics plotted as a vertical dashed line.}

\item{seed}{The value of the random number seed. Preset by default to allow reproducability.}
}
\value{
An object of class \code{pvalue.table} containing the cross-tabulation of p-values
for comparing the two classes
}
\description{
Compares the rates of two variables against one another.
}

