% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetAnswers.R
\name{GetAnswers}
\alias{GetAnswers}
\title{Get all the answers of a form.}
\usage{
GetAnswers(token, idForm, nameForm = NULL, singleDataFrame = FALSE,
  source = NULL, createdAfter = NULL, createdBefore = NULL,
  createdDeviceAfter = NULL, createdDeviceBefore = NULL,
  updatedAfter = NULL, updatedBefore = NULL)
}
\arguments{
\item{token}{String access token.}

\item{idForm}{Numeric Id of the required form.}

\item{nameForm}{String name of the required form. Just is used when an idForm
is not supplied. When this parameter is used, are spent extra one access
quota.}

\item{singleDataFrame}{Boolean flag. Indicates the preference to create a
single data frame with all the answers. In this case, is possible to have
repeated values, according to the multiplicity of relationships.}

\item{source}{Optional filter. Is the the source of the answer and can use
"web_public", "web_private" or "mobile".}

\item{createdAfter}{Optional filter. This parameter filters the answers that
were answered after this date. Is acceptable in the ISO8601 format
("YYYY-MM-DD" or "YYYY-MM-DDThh:mm:ssTZD").}

\item{createdBefore}{Optional filter. This parameter filters the answers
that were answered before this date. Is acceptable in the ISO8601 format
("YYYY-MM-DD" or "YYYY-MM-DDThh:mm:ssTZD").}

\item{createdDeviceAfter}{Optional filter. This parameter filters the answers
that were answered after this date on device time. Is acceptable in the
ISO8601 format ("YYYY-MM-DD" or "YYYY-MM-DDThh:mm:ssTZD").}

\item{createdDeviceBefore}{Optional filter. This parameter filters the
answers that were answered before this date on device time. Is acceptable in
the ISO8601 format ("YYYY-MM-DD" or "YYYY-MM-DDThh:mm:ssTZD").}

\item{updatedAfter}{Optional filter. This parameter filters the answers that
were updated after this date. Is acceptable in the ISO8601 format
("YYYY-MM-DD" or "YYYY-MM-DDThh:mm:ssTZD").}

\item{updatedBefore}{Optional filter. This parameter filters the answers
that were updated before this date. Is acceptable in the ISO8601 format
("YYYY-MM-DD" or "YYYY-MM-DDThh:mm:ssTZD").}
}
\value{
A list, with one or more data frames.
}
\description{
Get all the currents answers of a specific form. This function makes a call
to GetFormStructure and spent 2 quotas.
}
\details{
To get more details about the fields provided by the result, please visit the
\href{https://coletum.docs.apiary.io/#reference/0/preenchimentos/listar-preenchimentos}{API documentation}.
}
\examples{
\donttest{
GetAnswers("cizio7xeohwgc8k4g4koo008kkoocwg", 5705)
GetAnswers("cizio7xeohwgc8k4g4koo008kkoocwg", ,"RColetum Test - Iris", TRUE)
GetAnswers(token = "cizio7xeohwgc8k4g4koo008kkoocwg",
             nameForm = "RColetum Test - Iris")
GetAnswers(token = "cizio7xeohwgc8k4g4koo008kkoocwg",
             idForm = 5705,
             source = NULL,
             createdAfter = "2012-12-20",
             createdBefore = "2018-12-20"
             )
GetAnswers(token = "cizio7xeohwgc8k4g4koo008kkoocwg",
             idForm = 5705,
             source = NULL,
             createdAfter = "2012-12-20",
             createdBefore = "2018-12-20T19:20:30+01:00"
             )
GetAnswers(token = "cizio7xeohwgc8k4g4koo008kkoocwg",
             idForm = 5705,
             source = NULL,
             createdAfter = "2012-12-20T19:20:30Z",
             createdBefore = "2018-12-20T19:20:30+01:00"
             )
GetAnswers(token = "cizio7xeohwgc8k4g4koo008kkoocwg",
             idForm = 5705,
             source = "web_public",
             createdAfter = "2012-12-20T19:20:30+01:00",
             createdBefore = "2018-12-20T19:20:30+01:00"
             )
GetAnswers(token = "cizio7xeohwgc8k4g4koo008kkoocwg",
             idForm = 5705,
             singleDataFrame = TRUE,
             source = "web_private",
             createdAfter = "2012-12-20T19:20:30Z",
             createdBefore = "2018-12-20T19:20:30Z"
             )
GetAnswers(token = "cizio7xeohwgc8k4g4koo008kkoocwg",
             idForm = 5705,
             singleDataFrame = TRUE,
             source = "web_private",
             createdAfter = "2012-12-20T19:20:30Z",
             createdBefore = "2018-12-20T19:20:30Z",
             createdDeviceAfter = "2012-12-20T19:20:30Z",
             createdDeviceBefore = "2018-12-20T19:20:30Z",
             updatedAfter = "2018-05-20T19:20:30Z",
             updatedBefore = "2018-06-20T19:20:30Z"
             )
}

}
