% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{PhasesTransition}
\alias{PhasesTransition}
\title{Transition range between two successive phases (for phases in temporal order constraint)}
\usage{
PhasesTransition(Phase1End_chain, Phase2Beginning_chain, level = 0.95,
  max_decimal = 0)
}
\arguments{
  \item{Phase1End_chain}{numeric vector containing the output of the MCMC algorithm for the end of the oldest phase}
  \item{Phase2Beginning_chain}{numeric vector containing the output of the MCMC algorithm for the beginning of the following phase}
  \item{level}{probability corresponding to the level of confidence}
  \item{max_decimal}{maximum number of decimal}
}
\value{
Returns a vector of values containing the level of confidence and the endpoints of the transition interval between the successive phases
}
\description{
Finds if it exists the shortest interval [TransitionRangeInf , TransitionRangeSup ] that satisfies : P(TransitionRangeInf < Phase1End < Phase2Beginning < TransitionRangeSup  | M) = level
}

\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Phases); attach(Phases)
  PhasesTransition(Phase.1.beta, Phase.2.alpha, 0.95)
  PhasesTransition(Phase.1.beta, Phase.2.alpha, 0.50)
}
\keyword{ transition between two phases}
\keyword{ temporal order}
