% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau_min.R
\name{tau_min_probability}
\alias{tau_min_probability}
\title{tau_min_probability() computes the minimum detectable difference between control group and each treatment for a dichotomous variable}
\usage{
tau_min_probability(
  prior,
  N,
  power = 0.8,
  significance = 0.05,
  share_control,
  n_groups = 2
)
}
\arguments{
\item{prior}{Pr(Y=1).}

\item{N}{number of observations in the RCT, usually nrow(data)}

\item{power}{The level of power of the test (1 - Pr(Reject H_0 | H_0 True) ). Default is 0.8}

\item{significance}{The level of significance of the test Pr(Reject H_0 | H_0 False). Default is 0.05}

\item{share_control}{The share of observations in N assigned to control. This argument allows for sequences (i.e. seq(0,1,0.1))}

\item{n_groups}{Number of groups (control + # treatment groups)}
}
\value{
A tibble with the share_control and N observations in control group (N_control), 
the share and N of each treatment c(share_ti, N_ti), 
total share of treatment rows and N treated (share_treat, N_treat), N, 
the minimum detectable difference between control and all treatments together (tau_min_global),
the minimum detectable difference between control and each treatment (tau_min_each_treat)
}
\description{
tau_min_probability() computes the minimum detectable difference between control group and each treatment for a dichotomous variable
}
\details{
This function calculates the minimum difference that could show significant 
Pr[Y(1)-Y(0)] = tau, between any two given groups (e.g. control vs each treatment), given the 
population size (N), the outcome variable, power and significance
}
\examples{
tau_min_probability(0.4, N = 1000, share_control = seq(0,1,0.1), n_groups = 3)
}
