% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampdistC.r
\name{sampdistC}
\alias{sampdistC}
\title{Plots probability and cumulative density functions (PDFs and CDFs) of sample statistics}
\usage{
sampdistC(stat, se, t.df, plot.cdf = FALSE, ci = 95, digits = 3,
  printC = FALSE)
}
\arguments{
\item{stat}{A numeric statistic, the point estimate of a parameter based on a sample of observations, like a sample mean or a sample proportion.}

\item{se}{The standard error of the statistic, must be a positive number.}

\item{t.df}{(Optional) If critical values for sampling distribution should be based on t-distribution (generally true when statistic is a mean), set t.df to the number of degrees of freedom (typically n-1).}

\item{plot.cdf}{(Optional) Do you want to plot the cumulative density function? Default = FALSE (for probability density function).}

\item{ci}{(Optional) Specify desired confidence level for confidence interval as a percentage. Set ci=FALSE to suppress CI table (default: 95)}

\item{digits}{(Optional) Number of digits after decimal to display in CI table (default: 3)}

\item{printC}{(Optional) Do you want to sampling distribution plot to .html file in working directory? (default: FALSE)}
}
\value{
None (makes a plot)
}
\description{
Visualize expected sampling distributions for sample statistics. You can plot the probability and cumulative density functions for statistics based on either the normal distribution or a t-distribution.
The \code{sampdistC} function also generates the confidence interval (default 95\%) for a sample statistic which is useful for obtaining the CI of a summary statistic (when you're not estimating it from the dataset yourself).
}
\section{RCPA3 Package Tutorial Videos}{

\itemize{
\item \href{https://www.youtube.com/watch?v=Tz5wlmo1Jzk}{Viewing Sampling Distributions with RCPA3's sampdistC Function} 21:51
\item \href{https://www.youtube.com/playlist?list=PL3jY4WDTUxoNqrxSSQH4q7XPLPYipeNCu}{Complete Playlist of RCPA3 Package Tutorial Videos}, includes video for this function and many more.
}
}

\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 8.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), Chapter 6. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=8}{R Tutorials & Resources for Foundations of Inference}, Compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
 
  library(RCPA3)

  \donttest{
  # based on normal distributions
  sampdistC(stat=10, se=1)
  sampdistC(stat=10, se=1, plot.cdf=TRUE)
  
  # based on t-distribution with 15 degrees of freedom
  sampdistC(stat=8, se=2, t.df=15)
  sampdistC(stat=8, se=2, t.df=15, plot.cdf=TRUE)
  }
}
