% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pchisqC.r
\name{pchisqC}
\alias{pchisqC}
\title{Compares full v. reduced logistic regression models with Chi-Squared test}
\usage{
pchisqC(reduced, full, digits = 3)
}
\arguments{
\item{reduced}{The reduced logistic regression model as an object. This is model with fewer independent variables.}

\item{full}{The full logistic regression model as an object. This is model with more independent variables.}

\item{digits}{(Optional) The number of digits to display after decimal point, default is 3.}
}
\value{
The chi-squared statistic, df, and p-value as a vector of numbers to test null hypothesis that full model no better than reduced model.
}
\description{
Compares full and reduced logistic regression models with Chi-Square Test to assess whether additional variables of full model are statistically significant.
}
\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 14.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), Chapter 9. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\examples{
   library(RCPA3)
   
   \donttest{
   model_full <- logregC(battleground2020 ~ vep16.turnout + adv.or.more, data=states)
   model_reduced <- logregC(battleground2020 ~ vep16.turnout, data=states)
   
   pchisqC(reduced=model_reduced, full=model_full)
   }
}
\keyword{internal}
