% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGlobalStat.R
\name{makeGlobalStat}
\alias{makeGlobalStat}
\title{Compute global statistic of a variable}
\usage{
makeGlobalStat(x, area = NULL, verbose = FALSE, sortData = FALSE,
  FUN = cmip5.weighted.mean, ...)
}
\arguments{
\item{x}{A \code{\link{cmip5data}} object}

\item{area}{An area \code{\link{cmip5data}} object}

\item{verbose}{logical. Print info as we go?}

\item{sortData}{logical. Sort \code{x} and \code{area} before computing?}

\item{FUN}{function. Function to apply across grid}

\item{...}{Other arguments passed on to \code{FUN}}
}
\value{
A \code{\link{cmip5data}} object, in which the \code{val} dimensions are the
same as the caller for Z (if present) and time, but lon and lat are reduced to 
1 (i.e. no dimensionality). A \code{numCells} field is also added, recording the number
of cells in the spatial grid.
}
\description{
Calculates a global summary for CMIP5 data, usually weighted by the 
grid cell areas used by each particular model. If no
area weighting is supplied, one is computed based on the lon/lat
values of \code{x}. The default statistic is \link{weighted.mean},
but any summary function that returns a numeric result can be used.
}
\details{
The stat function is calculated for all combinations of lon,
lat, and Z (if present).
This function is more complicated than the other make...Stat functions, because
it provides explicit support for area-weighted functions. We expect that 
weighted.mean and a weighted sum will be the most frequent
calculations needed. Note that the base R \code{weighted.mean} function doesn't
work well for CMIP5 data, and so \code{cmip5.weighted.mean} is used as a default
function. Any other user-supplied stat function must 
follow the weighted.mean syntax, in particular accepting parameters 'x' 
(data) and 'w' (weights) of equal size, as well as dots(...).
}
\note{
If \code{x} and optional \code{area} are not in the same order, make
sure to specify \code{sortData=TRUE}.
}
\examples{
d <- cmip5data(1970:1975)   # sample data
makeGlobalStat(d)
summary(makeGlobalStat(d))
}
\seealso{
\code{\link{makeAnnualStat}} \code{\link{makeZStat}} \code{\link{makeMonthlyStat}} \code{\link{cmip5.weighted.mean}}
}

