% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCMIP5.R
\name{loadCMIP5}
\alias{loadCMIP5}
\title{Load CMIP5 data}
\usage{
loadCMIP5(variable, model, experiment, ensemble = "[^_]+", domain = "[^_]+",
  path = ".", recursive = TRUE, verbose = FALSE, force.ncdf = FALSE,
  FUN = mean, yearRange = NULL, ZRange = NULL, loadAs = "data.frame")
}
\arguments{
\item{variable}{CMIP5 variable to load (required)}

\item{model}{CMIP5 model to load (required)}

\item{experiment}{CMIP5 experiment to load (required)}

\item{ensemble}{optional CMIP5 ensemble to load}

\item{domain}{optional CMIP5 domain to load}

\item{path}{root of directory tree}

\item{recursive}{logical. Should we recurse into directories?}

\item{verbose}{logical. Print info as we go?}

\item{force.ncdf}{Force use of the less-desirable ncdf package for testing?}

\item{FUN}{function. Function (mean, min, max, or sum) to apply across ensembles}

\item{yearRange}{numeric of length 2. If supplied, load only years of data in this range}

\item{ZRange}{numeric of length 2. If supplied, load only Z data within this range.}

\item{loadAs}{a string identifying possible structures for values. Currently: 'data.frame' and 'array' the only valid options.}
}
\value{
A \code{\link{cmip5data}} object, or \code{NULL} if nothing loaded
}
\description{
Loads CMIP5 data from disk. \code{loadCMIP5} will return a unique model ensemble,
or will apply a function across all ensemble members of a
specified experiment-variable-model combination.
}
\note{
The \code{yearRange} parameter is intended to help users deal with large
CMIP5 data files on memory-limited machines, e.g. by allowing them to process
smaller chunks of such files.

FUN is limited to min, max, sum, and mean (the default), because the
memory costs of keeping all ensembles in memory is too high. Be warned that
min and max are quite slow!
}
\examples{
\dontrun{
loadCMIP5(experiment='rcp85', variable='prc', model='GFDL-CM3', ensemble='r1i1p1')
}
}

