% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBF-fn.R
\name{backf.rob}
\alias{backf.rob}
\title{Robust Backfitting}
\usage{
backf.rob(formula, data, subset, windows, point = NULL,
  epsilon = 1e-06, degree = 0, sigma.hat = NULL, prob = NULL,
  max.it = 50, k.h = 1.345, k.t = 4.685, type = "Huber")
}
\arguments{
\item{formula}{an object of class \code{formula} (or one that can be coerced to 
that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible 
by \link{as.data.frame} to a data frame) containing the variables in the model. 
If not found in \code{data}, the variables are taken from \code{environment(formula)}, 
typically the environment from which the function was called.}

\item{subset}{an optional vector specifying a subset of observations to be used in 
the fitting process.}

\item{windows}{vector of bandwidths for the local polynomial smoother,
one per explanatory variable.}

\item{point}{matrix of points where predictions will be computed and returned.}

\item{epsilon}{convergence criterion. Maximum allowed relative difference between
consecutive estimates}

\item{degree}{degree of the local polynomial smoother. Defaults to \code{0} (local constant).}

\item{sigma.hat}{estimate of the residual standard error. If \code{NULL} (default) we use the
\link{mad} of the residuals obtained with local medians.}

\item{prob}{vector of probabilities of observing each response (length n).
Defaults to \code{NULL} and in that case it is ignored.}

\item{max.it}{Maximum number of iterations for the algorithm.}

\item{k.h}{tuning constant for a Huber-type loss function.}

\item{k.t}{tuning constant for a Tukey-type loss function.}

\item{type}{one of either \code{'Tukey'} or \code{'Huber'}.}
}
\value{
A list with the following components:
\item{alpha}{Estimate for the intercept.}
\item{g.matrix }{Matrix of estimated additive components (n by p).}
\item{prediction }{Matrix of estimated additive components for the points listed in
the argument \code{point}.}
\item{sigma.hat }{Estimate of the residual standard error.}
}
\description{
This function computes a robust backfitting algorithm for additive models
}
\details{
This function computes a robust backfitting algorithm for additive models
using robust local polynomial smoothers.
}
\examples{
data(airquality)
tmp <- backf.rob(Ozone ~ Solar.R + Wind + Temp, data=airquality, 
subset=complete.cases(airquality), windows=c(136.7, 8.9, 4.8), degree=1)

}
\references{
Boente G, Martinez A, Salibian-Barrera M. Robust estimators
for additive models using backfitting. Journal of Nonparametric Statistics,
2017; 29:744-767. https://doi.org/10.1080/10485252.2017.1369077
}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}, Alejandra Martinez
}
