% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bysite.R
\name{aqs_monitors_by_site}
\alias{aqs_monitors_by_site}
\title{aqs_monitors_by_site}
\usage{
aqs_monitors_by_site(
  parameter,
  bdate,
  edate,
  stateFIPS,
  countycode,
  sitenum,
  cbdate = NA_Date_,
  cedate = NA_Date_,
  return_header = FALSE
)
}
\arguments{
\item{parameter}{a character list or a single character string
which represents the parameter code of the air
pollutant related to the data being requested.}

\item{bdate}{a R date object which represents that begin date of the data
selection. Only data on or after this date will be returned.}

\item{edate}{a R date object which represents that end date of the data
selection. Only data on or before this date will be returned.}

\item{stateFIPS}{a R character object which represents the 2 digit state
FIPS code (with leading zero) for the state being
requested. @seealso \code{\link[=aqs_states]{aqs_states()}} for the list of
available FIPS codes.}

\item{countycode}{a R character object which represents the 3 digit state
FIPS code for the county being requested (with leading
zero(s)). @seealso \code{\link[=aqs_counties_by_state]{aqs_counties_by_state()}} for the
list of available county codes for each state.}

\item{sitenum}{a R character object which represents the 4 digit site number
(with leading zeros) within the county and state being
requested.}

\item{cbdate}{a R date object which represents a "beginning
date of last change" that indicates when the data was last
updated. cbdate is used to filter data based on the change
date. Only data that changed on or after this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{cedate}{a R date object which represents an "end
date of last change" that indicates when the data was last
updated. cedate is used to filter data based on the change
date. Only data that changed on or before this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{return_header}{If FALSE (default) only returns data requested.
If TRUE returns a AQSAPI_v2 object which is a two
item list that contains header information returned
from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object of monitors from a
selected site
}
\description{
\lifecycle{stable}
Returns a table of monitors at all sites with the provided parameternum,
stateFIPS, county_code, and sitenum for bdate - edate time frame.
}
\note{
all monitors that operated between the bdate and edate will be returned
}
\section{by_site aggregate functions}{
NA
}

\examples{
 #Returns a tibble of the SO2 monitors at Hawaii
 #  Volcanoes NP site (\#0007) in Hawaii County, HI that were operating on
 #  May 1 , 2015. (Note, all monitors that operated between the bdate and
 #  edate will be returned)
 \dontrun{
           aqs_monitors_by_site(parameter = "42401",
                                  bdate = as.Date("20150501",
                                                     format="\%Y\%m\%d"),
                                  edate = as.Date("20150502",
                                                     format="\%Y\%m\%d"),
                                  stateFIPS = "15",
                                  countycode = "001",
                                  sitenum = "0007"
                                 )
         }

}
\seealso{
Other Aggregate _by_site functions: 
\code{\link{aqs_annualsummary_by_site}()},
\code{\link{aqs_dailysummary_by_site}()},
\code{\link{aqs_qa_blanks_by_site}()},
\code{\link{aqs_qa_collocated_assessments_by_site}()},
\code{\link{aqs_qa_flowrateaudit_by_site}()},
\code{\link{aqs_qa_flowrateverification_by_site}()},
\code{\link{aqs_qa_one_point_qc_by_site}()},
\code{\link{aqs_qa_pep_audit_by_site}()},
\code{\link{aqs_sampledata_by_site}()},
\code{\link{aqs_services_by_site}()},
\code{\link{aqs_transactionsample_by_site}()}
}
\concept{Aggregate _by_site functions}
