% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc.get.csv.data.R
\name{rc.get.csv.data}
\alias{rc.get.csv.data}
\title{rc.get.csv.data}
\usage{
rc.get.csv.data(
  csv = NULL,
  phenoData = NULL,
  idmsms = NULL,
  ExpDes = NULL,
  sampNameCol = 1,
  st = NULL,
  timepos = 2,
  featdelim = "_",
  ensure.no.na = TRUE
)
}
\arguments{
\item{csv}{filepath: csv input. Features as columns, rows as samples. Column header mz_rt}

\item{phenoData}{character: character string in 'taglocation' to designate files as either MS / DIA(MSe, MSall, AIF, etc) e.g. "01.mzML"}

\item{idmsms}{filepath: optional idMSMS / MSe csv data.  same dim and names as ms required}

\item{ExpDes}{either an R object created by R ExpDes object: data used for record keeping and labelling msp spectral output}

\item{sampNameCol}{integer: which column from the csv file contains sample names?}

\item{st}{numeric: sigma t - time similarity decay value}

\item{timepos}{integer: which position in delimited column header represents the retention time}

\item{featdelim}{character: how feature mz and rt are delimited in csv import column header e.g. ="-"}

\item{ensure.no.na}{logical: if TRUE, any 'NA' values in msint and/or msmsint are replaced with numerical values based on 10 percent of feature min plus noise.  Used to ensure that spectra are not written with NA values.}
}
\value{
an empty ramclustR object.  this object is formatted as an hclust object with additional slots for holding feature and compound data. details on these found below.

$frt: feature retention time, in whatever units were fed in

$fmz: feature retention time, reported in number of decimal points selected in ramclustR function

$ExpDes: the experimental design object used when running ramclustR.  List of two dataframes.

$MSdata:  the MSdataset provided by either xcms or csv input

$MSMSdata: the (optional) DIA(MSe, MSall, AIF etc) dataset

$xcmsOrd: original xcms order of features, for back-referencing when necessary

$msint: weighted.mean intensity of feature in ms level data

$msmsint:weighted.mean intensity of feature in msms level data
}
\description{
extractor for csv objects in preparation for normalization and clustering
}
\details{
This function creates a ramclustObj which will be used as input for clustering.
}
\examples{
## Choose csv input file. Features as columns, rows as samples
## Choose csv input file phenoData 
filename <- system.file("extdata", "peaks.csv", package = "RAMClustR", mustWork = TRUE)
phenoData <- system.file("extdata", "phenoData.csv", package = "RAMClustR", mustWork = TRUE)

ramclustobj <- rc.get.csv.data(csv = filename, phenoData = phenoData, st = 5)

}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.

Broeckling CD, Ganna A, Layer M, Brown K, Sutton B, Ingelsson E, Peers G, Prenni JE. Enabling Efficient and Confident Annotation of LC-MS Metabolomics Data through MS1 Spectrum and Time Prediction. Anal Chem. 2016 Sep 20;88(18):9226-34. doi: 10.1021/acs.analchem.6b02479. Epub 2016 Sep 8. PubMed PMID: 7560453.
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{clustering}
\concept{feature}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
\concept{xcms}
