% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQueue.R
\docType{data}
\name{RQueue}
\alias{RQueue}
\title{The RQueue reference class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
RQueue
}
\description{
The RQueue reference class implements the data structure queue.
}
\details{
A queue is an ordered list of items following the First-In-First-Out (FIFO) principle.
The \code{enqueue} method takes elements and enqueue them into the queue,
while the \code{dequeue} method returns and removes the earliest enqueued element in the queue.

The elements in the queue are not necessarily to be of the same type,
and they can even be of function type.
}
\section{References}{

For the details about the queue data structure, see \href{https://en.wikipedia.org/wiki/Queue_(abstract_data_type)}{Queue at Wikipedia}.
}

\section{Mutable Methods}{


The mutable methods changes the nodes of the instance.

\describe{

\item{\code{enqueue(..., collapse=NULL)}}{
The \code{enqueue} method creates nodes containing the values in \code{...} and \code{collapse},
and push them into the deque from the right,
which is equivalent to the \code{push} in \code{\link{RStack}}.
}

\item{\code{dequeue()}}{
The \code{dequeue} method returns and removes the leftmost element in the deque.
It returns \code{NULL} if the queue is empty.
}

}
}

\examples{

### create a new instance

# to create a new instance of the class
queue <- RQueue$new()

# the previous RQueue instance will be removed by running the following
# and the memory allocated for that one will be cleared,
# as now, the variable queue points to another instance of the class.
queue <- RQueue$new(0, 1, 2, collapse=list(3, 4))
# the following sentence is equivalent to the above
queue <- RQueue$new(0, 1, 2, 3, 4)
# where the numbers 0, 1, 2, 3, 4 are enqueued into the queue

### enqueue elements

# it can be one single element
queue$enqueue(5)
# it can be several elements separated by commas
# note the whole list will be one element of the queue
# because it is not passed through the collapse argument
queue$enqueue(list(a=10,b=20), "Hello world!")
# the collapse argument takes a list whose elements will be collapsed
# but the elements' names will not be saved
queue$enqueue(collapse = list(x=100,y=200))
# they can be used together
queue$enqueue("hurrah", collapse = list("RQueue",300))

### dequeue an element

# dequeue only one element at a time
val <- queue$dequeue()
# then we keep dequeuing!
while(!is.null(val)) val <- queue$dequeue()

}
\seealso{
\link{R6DS} for the introduction of the reference class and some common methods
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{RQueue}
