% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_optimal_asset_allocation.R
\name{calc_optimal_asset_allocation}
\alias{calc_optimal_asset_allocation}
\title{Calculate optimal asset allocation}
\usage{
calc_optimal_asset_allocation(
  household,
  portfolio,
  current_date = get_current_date()
)
}
\arguments{
\item{household}{An R6 object of class \code{Household}.}

\item{portfolio}{A nested \code{tibble} of class \code{Portfolio}.}

\item{current_date}{A character. Current date in the format \code{YYYY-MM-DD}.
By default, it is the output of \code{\link[=get_current_date]{get_current_date()}}.}
}
\value{
The \code{portfolio} with additional nested columns:
\itemize{
\item \code{allocations$optimal} - optimal joint net-worth portfolio allocations
\item \code{allocations$current} - current allocations
}
}
\description{
Calculate optimal asset allocation
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
older_member <- HouseholdMember$new(
  name       = "older",  
  birth_date = "1980-02-15",
  mode       = 80,
  dispersion = 10
)  
household <- Household$new()
household$add_member(older_member)  

household$expected_income <- list(
  "income" = c(
    "members$older$age <= 65 ~ 7000 * 12"
  )
)
household$expected_spending <- list(
  "spending" = c(
    "TRUE ~ 5000 * 12"
  )
)

portfolio <- create_portfolio_template() 
portfolio$accounts$taxable <- c(10000, 30000)

portfolio <- 
  portfolio |> 
  calc_effective_tax_rate(
    tax_rate_ltcg = 0.20, 
    tax_rate_ordinary_income = 0.40
  )

portfolio <- 
  calc_optimal_asset_allocation(
   household = household,
   portfolio = portfolio,
   current_date = "2020-07-15"
  )

portfolio$allocations
\dontshow{\}) # examplesIf}
}
