\name{sa.time}
\alias{sa.time}
\title{Sensitivity analysis of basic reproduction ratio to begin/end dates}
\description{Sensitivity analysis of reproduction ratio using supported estimation methods.}
\usage{sa.time(incid, GT, begin = NULL, end = NULL, est.method, t = NULL, 
    date.first.obs = NULL, time.step = 1, res = NULL, ...)}
\arguments{
  \item{incid}{incident cases}
  \item{GT}{generation time distribution}
  \item{begin}{Vector of begins date of the estimation of epidemic}
  \item{end}{Vector of end dates of estimation of the epidemic}
  \item{est.method}{Estimation method used for sensitivity analysis}
  \item{t}{Dates vector to be passed to estimation function}
  \item{date.first.obs}{Optional date of first observation, if t not specified}
  \item{time.step}{Optional. If date of first observation is specified, number of day between each incidence observation}
  \item{res}{If specified, will extract most of data from a R0.R-class result already generated by est.R0 and run sensitivity analysis on it.}
  \item{\dots}{parameters passed to inner functions}
}
\details{By varying different pairs of begin and end dates,different estimates of reproduction ratio can be analyzed.

'begin' and 'end' vector must have the same length for the sensitivity analysis to run.
They can be provided either as "dates" or "numeric" values, depending on the other parameters (see \link{check.incid}).
If some begin/end dates overlap, they are ignored, and corresponding uncomputed data are set to NA.
Also, note that unreliable Rsquared values are achieved for very small time period (begin ~ end).
These values are not representative of the epidemic outbreak behaviour.}
\value{A list with components as a data frame:
\item{df}{data.frame object with all results from sensitivity analysis.}
\item{df.clean}{the same object, with NA rows removed. Used only for easy export of results.}
\item{mat.sen}{Matrix with values of R0 given begin (rows) and end (columns) dates.}
\item{begin}{Vector of begins date of the estimation of epidemic}
\item{end}{Vector of end dates of estimation of the epidemic}}

\author{Pierre-Yves Boelle, Thomas Obadia}




\examples{\dontrun{#Loading package
library(R0)

## Data is taken from the paper by Nishiura for key transmission parameters of an institutional
## outbreak during 1918 influenza pandemic in Germany)

data(Germany.1918)
mGT<-generation.time("gamma", c(2.6,1))
sen=sa.time(Germany.1918, mGT, begin=1:15, end=16:30, est.method="EG")

# ...
# Warning message:
# If 'begin' and 'end' overlap, cases where begin >= end are skipped.
# These cases often return Rsquared = 1 and are thus ignored.
## A list with different estimates of reproduction ratio, exponential growth rate and 95\%CI 
## wtih different pairs of begin and end dates in form of data frame is returned.
## If method is "EG", results will include growth rate and deviance R-squared measure
## Else, if "ML" method is used, growth rate and R-squared will be set as NA

## Interesting results include the variation of R0 given specific begin/end dates.
## Such results can be plot as a colored matrix and display Rsquared=f(time period)
plot(sen, what=c("criterion","heatmap"))
## Returns complete data.frame of best R0 value for each time period 
## (allows for quick visualization)
## The "best.fit" is the time period over which the estimate is the more robust

# $best.fit
#    Time.period Begin.dates  End.dates       R Growth.rate  Rsquared CI.lower. CI.upper.
# 92          15  1970-01-08 1970-01-23 1.64098   0.1478316 0.9752564  1.574953  1.710209}
}
