% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{build_dtm}
\alias{build_dtm}
\title{build_dtm}
\usage{
build_dtm(corpus, sparsity = 1, dictionary = NULL,
  remove_stopwords = FALSE, tolower = TRUE,
  remove_punctuation = TRUE, remove_numbers = TRUE)
}
\arguments{
\item{corpus}{A \code{Corpus} object.}

\item{sparsity}{Value between 0 and 1 indicating the proportion of documents
with no occurrences of a term above which that term should be dropped. By default
all terms are kept (\code{sparsity=1}).}

\item{dictionary}{A vector of terms. to which the matrix should be restricted.
By default, all words with more than one character are considered.}

\item{remove_stopwords}{Whether to remove stopwords appearing in a language-specific list
(see \code{\link[tm:stopwords]{tm::stopwords}}).}

\item{tolower}{Whether to convert all text to lower case.}

\item{remove_punctuation}{Whether to remove all punctuation from text before
tokenizing terms.}

\item{remove_numbers}{Whether to remove all numbers from text before
tokenizing terms.}
}
\value{
A \code{DocumentTermMatrix} object.
}
\description{
Compute document-term matrix from a corpus.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
build_dtm(corpus)

}
