% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.Hull.R
\name{plot.validation}
\alias{plot.validation}
\title{Hull Plot}
\usage{
\method{plot}{validation}(x, i, ...)
}
\arguments{
\item{x}{A \code{\link[Qval]{validation}} in which \code{method} = \code{"Hull"}.}

\item{i}{A numeric, which represents the item you want to plot Hull curve.}

\item{...}{Additional arguments.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function can provide the Hull plot. The point suggested by the Hull method is marked in red.
}
\examples{
set.seed(123)
library(Qval)

## generate Q-matrix and data
K <- 4
I <- 20
IQ <- list(
  P0 = runif(I, 0.2, 0.4),
  P1 = runif(I, 0.6, 0.8)
)

\donttest{
Q <- sim.Q(K, I)
data <- sim.data(Q = Q, N = 500, IQ = IQ, model = "GDINA", distribute = "horder")
MQ <- sim.MQ(Q, 0.1)

CDM.obj <- CDM(data$dat, MQ)

############### ESA ###############
Hull.obj <- validation(data$dat, MQ, CDM.obj, method = "Hull", search.method = "ESA") 

## plot Hull curve for item 20
plot(Hull.obj, 20)

############### PAA ###############
Hull.obj <- validation(data$dat, MQ, CDM.obj, method = "Hull", search.method = "PAA") 

## plot Hull curve for item 20
plot(Hull.obj, 20)
}
 


}
