% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_summaries.R
\name{summary.drFitSpline}
\alias{summary.drFitSpline}
\title{Generic summary function for drFitSpline objects}
\usage{
\method{summary}{drFitSpline}(object, ...)
}
\arguments{
\item{object}{object of class \code{drFitSpline}}

\item{...}{Additional arguments. This has currently no effect and is only meant to fulfill the requirements of a generic function.}
}
\value{
A dataframe with parameters extracted from the dose-response analysis of a single sample.
}
\description{
Generic summary function for drFitSpline objects
}
\examples{
conc <- c(0, rev(unlist(lapply(1:18, function(x) 10*(2/3)^x))),10)
response <- c(1/(1+exp(-0.7*(4-conc[-20])))+rnorm(19)/50, 0)

TestRun <- growth.drFitSpline(conc, response, drID = 'test',
              control = growth.control(log.x.dr = TRUE, smooth.dr = 0.8))

print(summary(TestRun))

}
