% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetDistance.R
\name{QuartetState}
\alias{QuartetState}
\alias{QuartetStates}
\title{Quartet State(s)}
\usage{
QuartetState(tips, bips, splits = bips)

QuartetStates(splits)
}
\arguments{
\item{tips}{A four-element array listing a quartet of tips, either by their
number (if class \code{numeric}) or their name (if class \code{character}).}

\item{bips}{Depreciated; included for compatibility with v1.0.2 and below.}

\item{splits}{An object that can be induced to a \code{Splits} object using
\code{\link[TreeTools]{as.Splits}}.}
}
\value{
\code{QuartetState} returns \code{0} if the relationships of the four taxa are
not constrained by the provided splits, or the index of the closest
relative to \code{tips[1]}, otherwise.
}
\description{
Report the status of the specified quartet(s).
}
\details{
One of the three possible four-taxon trees will be consistent with any set of
splits generated from a fully resolved tree.  If the taxa are numbered
1 to 4, this tree can be identified by naming the tip most closely related
to taxon 1.
If a set of splits is generated from a tree that contains polytomies,
it is possible that all three four-taxon trees are consistent with the set
of splits
}
\section{Functions}{
\itemize{
\item \code{QuartetStates}: A convenience wrapper that lists the status of all
possible quartets for a given \code{Splits} object.
}}

\examples{
{
  nTip <- 6
  trees <- list(ape::rtree(nTip, tip.label=seq_len(nTip), br=NULL),
                ape::rtree(nTip, tip.label=seq_len(nTip), br=NULL))
  
  trees[[3]] <- TreeTools::CollapseNode(trees[[2]], 9:10)
  
  QuartetState(c(1, 3, 4, 6), trees[[2]])  
  QuartetState(1:4, trees[[1]]) == QuartetState(1:4, trees[[2]])
  QuartetState(c(1, 3, 4, 6), trees[[3]])  
  
  QuartetStates(trees[[2]])
  QuartetStates(trees[[3]])
  
}

}
\references{
\insertRef{Estabrook1985}{Quartet}
}
\seealso{
\code{\link{CompareQuartets}}, used to compare quartet states between
trees.

Other element-by-element comparisons: \code{\link{CompareQuartets}},
  \code{\link{CompareSplits}},
  \code{\link{PairSharedQuartetStatus}},
  \code{\link{SharedQuartetStatus}},
  \code{\link{SplitStatus}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{element-by-element comparisons}
