% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust_fmx.R
\name{fmx_constraint}
\alias{fmx_constraint}
\alias{fmx_constraint_user}
\title{Parameter Constraint(s) of Mixture Distribution}
\usage{
fmx_constraint(
  dist,
  distname = dist@distname,
  K = dim(dist@parM)[1L],
  parM = dist@parM
)

fmx_constraint_user(distname, K, user)
}
\arguments{
\item{dist}{an \code{'fmx'} object, can be missing}

\item{distname, K, parM}{the name of distribution, the number of components and the matrix of distribution parameters of a finite mixture distribution}

\item{user}{an user-specified \code{'character'} vector to denote the constraint(s) to be 
imposed for a finite mixture distribution.  For example, for a two-component Tukey's \eqn{g}-&-\eqn{h}
mixture, \code{user = c('g2', 'h1')} indicates the \eqn{g}-parameter for the first component (with smaller mean value)
and the \eqn{h}-parameter for the second component (with larger mean value) are to be constrained, i.e., \eqn{g_2=h_1=0}.}
}
\value{
\code{\link{fmx_constraint}} returns the indexes of internal parameters 
(only applicable to Tukey's \eqn{g}-&-\eqn{h} mixture distribution, yet) to be constrained, 
based on the input \code{'fmx'} object \code{dist}.

\code{\link{fmx_constraint_user}} returns the indexes of internal parameters 
(only applicable to Tukey's \eqn{g}-&-\eqn{h} mixture distribution, yet) to be constrained, 
based on the type of distribution (\code{distname}), number of components (\code{K}) 
and a user-specified string (e.g., \code{c('g2', 'h1')}).
}
\description{
Determine the parameter constraint(s) of a finite mixture distribution, either by the 
the given parameters of such mixture distribution, or by a user-specified string.
}
\examples{
(d = fmx('GH', A = c(1,4), g = c(.2,0), h = c(0,.1), w = c(1,1)))
(c1 = fmx_constraint(d))
(c2 = fmx_constraint_user(distname = 'GH', K = 2L, user = c('g2', 'h1')))

(d0 = fmx('GH', A = c(1,4), g = c(.2,.1), h = c(.05,.1), w = c(1,1)))
(c3 = fmx_constraint(d0))
(c4 = fmx_constraint_user(distname = 'GH', K = 2L, user = character()))

stopifnot(identical(c1, c2), identical(c3, c4))

}
