% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step_fmx.R
\name{Step_fmx}
\alias{Step_fmx}
\title{Backward Selection \eqn{gh}-parsimonious Model with Fixed Number of Components}
\usage{
Step_fmx(object, by = c("logLik", "AIC", "BIC"), silent = FALSE, ...)
}
\arguments{
\item{object}{\code{'fmx_QLMDe'} object returned from \code{\link{QLMDe}}}

\item{by}{criterion, currently supporting 
\code{'logLik'} (via my \code{\link{LikRatio}}, likelihood ratio test, default and recommended), 
\code{'AIC'} (via \code{\link[stats]{AIC}}) and 
\code{'BIC'} (via \code{\link[stats]{BIC}}).}

\item{silent}{'logical' value, whether messages should be suppressed (default \code{FALSE})}

\item{...}{additional parameters}
}
\value{
\code{\link{Step_fmx}} returns an \code{'fmx_QLMDe'} object, with attributes
\itemize{
\item{\code{anova}} {ANOVA table}
\item{\code{objF}} {value of the objective function (either the log-likelihood, AIC or BIC)}
}
}
\description{
The function \code{\link{Step_fmx}} selects a \eqn{gh}-parsimonious model with \eqn{g} and/or \eqn{h} parameters equal to zero 
for all or some of the mixture components conditionally on fixed number of components \eqn{K}.
}
\details{
The algorithm starts with quantile least Mahalanobis distance estimates (\code{\link{QLMDe}}) 
of either the full mixture of Tukey \eqn{g}-&-\eqn{h} distributions model, or
a constrained model (i.e., some \eqn{g} and/or \eqn{h} parameters equal to zero according to the user input).
Next, each of the non-zero \eqn{g} and/or \eqn{h} parameters is tested using the likelihood ratio test.
If all tested \eqn{g} and/or \eqn{h} parameters are significantly different from zero at the level 0.05
the algorithm is stopped and the initial model is considered \eqn{gh}-parsimonious.
Otherwise, the \eqn{g} or \eqn{h} parameter with the largest p-value is constrained to zero 
for the next iteration of the algorithm.

The algorithm iterates until only significantly-different-from-zero \eqn{g} and \eqn{h} parameters 
are retained, which corresponds to \eqn{gh}-parsimonious Tukey's \eqn{g}-&-\eqn{h} mixture model.
}
