% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QLMDe.R
\name{S3_fmx_QLMDe}
\alias{S3_fmx_QLMDe}
\alias{vcov.fmx_QLMDe}
\alias{coef.fmx}
\alias{confint.fmx_QLMDe}
\title{Inference for Quantile Least Mahalanobis Distance estimates}
\usage{
\method{vcov}{fmx_QLMDe}(object, parm = c("user", "internal"), ...)

\method{coef}{fmx}(object, parm = c("user", "internal"), ...)

\method{confint}{fmx_QLMDe}(object, parm = c("internal", "user"), level = 0.95, ...)
}
\arguments{
\item{object}{an \code{'fmx'} or \code{'fmx_QLMDe'} object}

\item{parm}{\code{'character'} value. Use \code{'user'} for the user-friendly parameters (e.g., \code{mean,sd} for normal, and \code{A,B,g,h} for Tukey's \eqn{g}-and-\eqn{h}), via delta-method.
Use \code{'internal'} for the internal/unconstrained parameters.}

\item{...}{place holder for S3 naming convention}

\item{level}{confidence level, default \eqn{95\%}.}
}
\value{
\code{\link{coef.fmx}} returns the estimates of the user-friendly parameters (\code{parm = 'user'}), 
or the internal/unconstrained parameters (\code{parm = 'internal'}).

\code{\link{vcov.fmx_QLMDe}} returns 
the approximate asymptotic variance-covariance matrix of the user-friendly parameters via delta-method (\code{parm = 'user'}), 
or the asymptotic variance-covariance matrix of the internal/unconstrained parameters (\code{parm = 'internal'}). 

\code{\link{confint.fmx_QLMDe}} returns the Wald-type confidence intervals based on the user-friendly parameters (\code{parm = 'user'}),
 or the internal/unconstrained parameters (\code{parm = 'internal'}).

When the distribution has constraints on one or more parameters, none of \code{\link{coef.fmx}}, \code{\link{vcov.fmx_QLMDe}} and 
\code{\link{confint.fmx_QLMDe}} will return the corresponding values only for the constrained parameters.
}
\description{
S3 method for \code{\link[stats]{vcov}}, \code{\link[stats]{coef}} and \code{\link[stats]{confint}}.
}
